/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.sword.BookType;
import org.crosswire.jsword.book.sword.ConfigEntry;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.versification.system.Versifications;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigEntryTable {
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final String ENCODING_LATIN1 = "WINDOWS-1252";
    private static final ConfigEntryType[] BASIC_INFO = new ConfigEntryType[]{ConfigEntryType.INITIALS, ConfigEntryType.DESCRIPTION, ConfigEntryType.CATEGORY, ConfigEntryType.LCSH, ConfigEntryType.SWORD_VERSION_DATE, ConfigEntryType.VERSION, ConfigEntryType.HISTORY, ConfigEntryType.OBSOLETES, ConfigEntryType.INSTALL_SIZE};
    private static final ConfigEntryType[] LANG_INFO = new ConfigEntryType[]{ConfigEntryType.LANG, ConfigEntryType.GLOSSARY_FROM, ConfigEntryType.GLOSSARY_TO};
    private static final ConfigEntryType[] COPYRIGHT_INFO = new ConfigEntryType[]{ConfigEntryType.ABOUT, ConfigEntryType.SHORT_PROMO, ConfigEntryType.DISTRIBUTION_LICENSE, ConfigEntryType.DISTRIBUTION_NOTES, ConfigEntryType.DISTRIBUTION_SOURCE, ConfigEntryType.SHORT_COPYRIGHT, ConfigEntryType.COPYRIGHT, ConfigEntryType.COPYRIGHT_DATE, ConfigEntryType.COPYRIGHT_HOLDER, ConfigEntryType.COPYRIGHT_CONTACT_NAME, ConfigEntryType.COPYRIGHT_CONTACT_ADDRESS, ConfigEntryType.COPYRIGHT_CONTACT_EMAIL, ConfigEntryType.COPYRIGHT_CONTACT_NOTES, ConfigEntryType.COPYRIGHT_NOTES, ConfigEntryType.TEXT_SOURCE};
    private static final ConfigEntryType[] FEATURE_INFO = new ConfigEntryType[]{ConfigEntryType.FEATURE, ConfigEntryType.GLOBAL_OPTION_FILTER, ConfigEntryType.FONT};
    private static final ConfigEntryType[] SYSTEM_INFO = new ConfigEntryType[]{ConfigEntryType.DATA_PATH, ConfigEntryType.MOD_DRV, ConfigEntryType.SOURCE_TYPE, ConfigEntryType.BLOCK_TYPE, ConfigEntryType.BLOCK_COUNT, ConfigEntryType.COMPRESS_TYPE, ConfigEntryType.ENCODING, ConfigEntryType.MINIMUM_VERSION, ConfigEntryType.OSIS_VERSION, ConfigEntryType.OSIS_Q_TO_TICK, ConfigEntryType.DIRECTION, ConfigEntryType.KEY_TYPE, ConfigEntryType.DISPLAY_LEVEL, ConfigEntryType.VERSIFICATION};
    private static final ConfigEntryType[] HIDDEN = new ConfigEntryType[]{ConfigEntryType.CIPHER_KEY};
    private String internal;
    private Map<ConfigEntryType, ConfigEntry> table = new HashMap<ConfigEntryType, ConfigEntry>();
    private Map<String, ConfigEntry> extra = new TreeMap<String, ConfigEntry>();
    private BookType bookType;
    private boolean supported;
    private boolean questionable;
    private String readahead;
    private File configFile;
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("^([A-Za-z0-9_.]+)\\s*=\\s*(.*)$");
    private static final Logger log = LoggerFactory.getLogger(ConfigEntryTable.class);

    public ConfigEntryTable(String bookName) {
        this.internal = bookName;
        this.supported = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        this.configFile = file;
        BufferedReader in = null;
        int bufferSize = 8192;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING_UTF8), bufferSize);
            this.loadInitials(in);
            this.loadContents(in);
            in.close();
            in = null;
            if (this.getValue(ConfigEntryType.ENCODING).equals(ENCODING_LATIN1)) {
                this.supported = true;
                this.bookType = null;
                this.questionable = false;
                this.readahead = null;
                this.table.clear();
                this.extra.clear();
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING_LATIN1), bufferSize);
                this.loadInitials(in);
                this.loadContents(in);
                in.close();
                in = null;
            }
            this.adjustDataPath();
            this.adjustLanguage();
            this.adjustBookType();
            this.adjustName();
            this.validate();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(byte[] buffer) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buffer), ENCODING_UTF8), buffer.length);
            this.loadInitials(in);
            this.loadContents(in);
            in.close();
            in = null;
            if (this.getValue(ConfigEntryType.ENCODING).equals(ENCODING_LATIN1)) {
                this.supported = true;
                this.bookType = null;
                this.questionable = false;
                this.readahead = null;
                this.table.clear();
                this.extra.clear();
                in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buffer), ENCODING_LATIN1), buffer.length);
                this.loadInitials(in);
                this.loadContents(in);
                in.close();
                in = null;
            }
            this.adjustDataPath();
            this.adjustLanguage();
            this.adjustBookType();
            this.adjustName();
            this.validate();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public boolean isQuestionable() {
        return this.questionable;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public boolean isEnciphered() {
        String cipher = (String)this.getValue(ConfigEntryType.CIPHER_KEY);
        return cipher != null;
    }

    public boolean isLocked() {
        String cipher = (String)this.getValue(ConfigEntryType.CIPHER_KEY);
        return cipher != null && cipher.length() == 0;
    }

    public boolean unlock(String unlockKey) {
        String tmpKey = unlockKey;
        if (tmpKey != null) {
            tmpKey = tmpKey.trim();
        }
        this.add(ConfigEntryType.CIPHER_KEY, tmpKey);
        if (this.configFile != null) {
            try {
                this.save();
            }
            catch (IOException e) {
                Reporter.informUser((Object)this, JSMsg.gettext("Unable to save the book's unlock key.", new Object[0]));
            }
        }
        return true;
    }

    public String getUnlockKey() {
        return (String)this.getValue(ConfigEntryType.CIPHER_KEY);
    }

    public Set<ConfigEntryType> getKeys() {
        return this.table.keySet();
    }

    public Set<String> getExtraKeys() {
        return this.extra.keySet();
    }

    public BookType getBookType() {
        return this.bookType;
    }

    public Object getValue(ConfigEntryType type) {
        ConfigEntry ce = this.table.get((Object)type);
        if (ce != null) {
            return ce.getValue();
        }
        return type.getDefault();
    }

    public boolean match(ConfigEntryType type, String search) {
        ConfigEntry ce = this.table.get((Object)type);
        return ce != null && ce.match(search);
    }

    public Element toOSIS() {
        OSISUtil.OSISFactory factory = OSISUtil.factory();
        Element ele = factory.createTable();
        this.toOSIS(factory, ele, "BasicInfo", BASIC_INFO);
        this.toOSIS(factory, ele, "LangInfo", LANG_INFO);
        this.toOSIS(factory, ele, "LicenseInfo", COPYRIGHT_INFO);
        this.toOSIS(factory, ele, "FeatureInfo", FEATURE_INFO);
        this.toOSIS(factory, ele, "SysInfo", SYSTEM_INFO);
        this.toOSIS(factory, ele, "Extra", this.extra);
        return ele;
    }

    public String toConf() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(this.getValue(ConfigEntryType.INITIALS));
        buf.append("]\n");
        this.toConf(buf, BASIC_INFO);
        this.toConf(buf, SYSTEM_INFO);
        this.toConf(buf, HIDDEN);
        this.toConf(buf, FEATURE_INFO);
        this.toConf(buf, LANG_INFO);
        this.toConf(buf, COPYRIGHT_INFO);
        this.toConf(buf, this.extra);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (this.configFile != null) {
            String encoding = ENCODING_LATIN1;
            if (this.getValue(ConfigEntryType.ENCODING).equals(ENCODING_UTF8)) {
                encoding = ENCODING_UTF8;
            }
            Writer writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), encoding);
                writer.write(this.toConf());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    public void save(File file) throws IOException {
        this.configFile = file;
        this.save();
    }

    private void loadContents(BufferedReader in) throws IOException {
        StringBuilder buf = new StringBuilder();
        while (true) {
            buf.setLength(0);
            String line = this.advance(in);
            if (line == null) break;
            if (line.length() == 0) continue;
            Matcher matcher = KEY_VALUE_PATTERN.matcher(line);
            if (!matcher.matches()) {
                log.warn("Expected to see '=' in {}: {}", (Object)this.internal, (Object)line);
                continue;
            }
            String key = matcher.group(1).trim();
            String value = matcher.group(2).trim();
            if (value.length() == 0 && !ConfigEntryType.CIPHER_KEY.getName().equals(key)) {
                log.warn("Ignoring empty entry in {}: {}", (Object)this.internal, (Object)line);
                continue;
            }
            ConfigEntry configEntry = new ConfigEntry(this.internal, key);
            ConfigEntryType type = configEntry.getType();
            ConfigEntry e = this.table.get((Object)type);
            if (e == null) {
                if (type == null) {
                    log.warn("Extra entry in {} of {}", (Object)this.internal, (Object)configEntry.getName());
                    this.extra.put(key, configEntry);
                } else if (type.isSynthetic()) {
                    log.warn("Ignoring unexpected entry in {} of {}", (Object)this.internal, (Object)configEntry.getName());
                } else {
                    this.table.put(type, configEntry);
                }
            } else {
                configEntry = e;
            }
            buf.append(value);
            this.getContinuation(configEntry, in, buf);
            value = buf.toString();
            if (ConfigEntryType.HISTORY.equals((Object)type)) {
                int pos = key.indexOf(95);
                value = key.substring(pos + 1) + ' ' + value;
            }
            configEntry.addValue(value);
        }
    }

    private void loadInitials(BufferedReader in) throws IOException {
        String line;
        String initials = null;
        while ((line = this.advance(in)) != null) {
            if (line.charAt(0) != '[' || line.charAt(line.length() - 1) != ']') continue;
            initials = line.substring(1, line.length() - 1);
            break;
        }
        if (initials == null) {
            log.error("Malformed conf file for {} no initials found. Using internal of {}", (Object)this.internal, (Object)this.internal);
            initials = this.internal;
        }
        this.add(ConfigEntryType.INITIALS, initials);
    }

    private void getContinuation(ConfigEntry configEntry, BufferedReader bin, StringBuilder buf) throws IOException {
        String line = this.advance(bin);
        while (line != null) {
            boolean continuation_expected;
            int length = buf.length();
            boolean bl = continuation_expected = length > 0 && buf.charAt(length - 1) == '\\';
            if (continuation_expected) {
                buf.deleteCharAt(length - 1);
            }
            if (this.isKeyLine(line)) {
                if (continuation_expected) {
                    log.warn("Continuation followed by key for {} in {}: {}", new Object[]{configEntry.getName(), this.internal, line});
                }
                this.backup(line);
                break;
            }
            if (!continuation_expected) {
                log.warn("Line without previous continuation for {} in {}: {}", new Object[]{configEntry.getName(), this.internal, line});
            }
            if (!configEntry.allowsContinuation()) {
                log.warn("Ignoring unexpected additional line for {} in {}: {}", new Object[]{configEntry.getName(), this.internal, line});
            } else {
                if (continuation_expected) {
                    buf.append('\n');
                }
                buf.append(line);
            }
            line = this.advance(bin);
        }
    }

    private String advance(BufferedReader bin) throws IOException {
        if (this.readahead != null) {
            String line = this.readahead;
            this.readahead = null;
            return line;
        }
        String trimmed = null;
        String line = bin.readLine();
        while (line != null) {
            trimmed = line.trim();
            int length = trimmed.length();
            if (length != 0 && trimmed.charAt(0) != '#') {
                return trimmed;
            }
            line = bin.readLine();
        }
        return null;
    }

    private void backup(String oops) {
        if (oops.length() > 0) {
            this.readahead = oops;
        } else {
            log.error("Backup an empty string for {}", (Object)this.internal);
        }
    }

    private boolean isKeyLine(String line) {
        return KEY_VALUE_PATTERN.matcher(line).matches();
    }

    public void add(ConfigEntryType type, String aValue) {
        this.table.put(type, new ConfigEntry(this.internal, type, aValue));
    }

    private void adjustDataPath() {
        String datapath = (String)this.getValue(ConfigEntryType.DATA_PATH);
        if (datapath == null) {
            datapath = "";
        }
        if (datapath.startsWith("./")) {
            datapath = datapath.substring(2);
        }
        this.add(ConfigEntryType.DATA_PATH, datapath);
    }

    private void adjustLanguage() {
        Language lang = (Language)this.getValue(ConfigEntryType.LANG);
        if (lang == null) {
            log.warn("Setting default lang for {}. Assuming {}={}", new Object[]{this.internal, ConfigEntryType.LANG.getName(), "en"});
            lang = Language.DEFAULT_LANG;
            this.add(ConfigEntryType.LANG, lang.getGivenSpecification());
        }
        this.testLanguage(this.internal, lang);
        Language langFrom = (Language)this.getValue(ConfigEntryType.GLOSSARY_FROM);
        Language langTo = (Language)this.getValue(ConfigEntryType.GLOSSARY_TO);
        if (langFrom != null || langTo != null) {
            if (langFrom == null) {
                log.warn("Missing data for {}. Assuming {}={}", new Object[]{this.internal, ConfigEntryType.GLOSSARY_FROM.getName(), lang.getGivenSpecification()});
                langFrom = lang;
                this.add(ConfigEntryType.GLOSSARY_FROM, langFrom.getGivenSpecification());
            }
            this.testLanguage(this.internal, langFrom);
            if (langTo == null) {
                log.warn("Missing data for {}. Assuming {}={}", new Object[]{this.internal, ConfigEntryType.GLOSSARY_TO.getName(), "en"});
                langTo = Language.DEFAULT_LANG;
                this.add(ConfigEntryType.GLOSSARY_TO, langTo.getGivenSpecification());
            }
            this.testLanguage(this.internal, langTo);
            if (!langFrom.equals(lang) && !langTo.equals(lang)) {
                log.error("Data error in {}. Neither {} or {} match {}", new Object[]{this.internal, ConfigEntryType.GLOSSARY_FROM.getName(), ConfigEntryType.GLOSSARY_TO.getName(), ConfigEntryType.LANG.getName()});
            } else if (!langFrom.equals(lang)) {
                lang = langFrom;
                this.add(ConfigEntryType.LANG, lang.getGivenSpecification());
            }
        }
    }

    private void adjustBookType() {
        BookCategory focusedCategory = (BookCategory)((Object)this.getValue(ConfigEntryType.CATEGORY));
        this.questionable = focusedCategory == BookCategory.QUESTIONABLE;
        String modTypeName = (String)this.getValue(ConfigEntryType.MOD_DRV);
        if (modTypeName == null) {
            log.error("Book not supported: malformed conf file for {} no {} found.", (Object)this.internal, (Object)ConfigEntryType.MOD_DRV.getName());
            this.supported = false;
            return;
        }
        String v11n = (String)this.getValue(ConfigEntryType.VERSIFICATION);
        if (!Versifications.instance().isDefined(v11n)) {
            log.error("Book not supported: Unknown versification for {}. {} is unknown.", (Object)this.internal, (Object)v11n);
            this.supported = false;
            return;
        }
        this.add(ConfigEntryType.VERSIFICATION, v11n);
        this.bookType = BookType.fromString(modTypeName);
        if (this.getBookType() == null) {
            log.error("Book not supported: malformed conf file for {} no book type found", (Object)this.internal);
            this.supported = false;
            return;
        }
        BookCategory basicCategory = this.getBookType().getBookCategory();
        if (basicCategory == null) {
            this.supported = false;
            return;
        }
        if (focusedCategory == BookCategory.OTHER || focusedCategory == BookCategory.QUESTIONABLE) {
            focusedCategory = this.getBookType().getBookCategory();
        }
        this.add(ConfigEntryType.CATEGORY, focusedCategory.getName());
    }

    private void adjustName() {
        if (this.table.get((Object)ConfigEntryType.DESCRIPTION) == null) {
            log.error("Malformed conf file for {}. No {} found. Using internal of {}", new Object[]{this.internal, ConfigEntryType.DESCRIPTION.getName(), this.internal});
            this.add(ConfigEntryType.DESCRIPTION, this.internal);
        }
    }

    private void validate() {
    }

    private void testLanguage(String initials, Language lang) {
        if (!lang.isValidLanguage()) {
            log.warn("Unknown language {} in book {}", (Object)lang.getGivenSpecification(), (Object)initials);
        }
    }

    private void toOSIS(OSISUtil.OSISFactory factory, Element ele, String aTitle, ConfigEntryType[] category) {
        Element title = null;
        for (int i = 0; i < category.length; ++i) {
            ConfigEntry entry = this.table.get((Object)category[i]);
            Element configElement = null;
            if (entry != null) {
                configElement = entry.toOSIS();
            }
            if (title == null && configElement != null) {
                title = factory.createHeader();
                title.addContent(aTitle);
                ele.addContent((Content)title);
            }
            if (configElement == null) continue;
            ele.addContent((Content)configElement);
        }
    }

    private void toConf(StringBuilder buf, ConfigEntryType[] category) {
        for (int i = 0; i < category.length; ++i) {
            String text;
            ConfigEntry entry = this.table.get((Object)category[i]);
            if (entry == null || entry.getType().isSynthetic() || (text = entry.toConf()) == null || text.length() <= 0) continue;
            buf.append(entry.toConf());
        }
    }

    private void toOSIS(OSISUtil.OSISFactory factory, Element ele, String aTitle, Map<String, ConfigEntry> map) {
        Element title = null;
        for (Map.Entry<String, ConfigEntry> mapEntry : map.entrySet()) {
            ConfigEntry entry = mapEntry.getValue();
            Element configElement = null;
            if (entry != null) {
                configElement = entry.toOSIS();
            }
            if (title == null && configElement != null) {
                title = factory.createHeader();
                title.addContent(aTitle);
                ele.addContent((Content)title);
            }
            if (configElement == null) continue;
            ele.addContent((Content)configElement);
        }
    }

    private void toConf(StringBuilder buf, Map<String, ConfigEntry> map) {
        for (Map.Entry<String, ConfigEntry> mapEntry : map.entrySet()) {
            ConfigEntry entry = mapEntry.getValue();
            String text = entry.toConf();
            if (text == null || text.length() <= 0) continue;
            buf.append(text);
        }
    }
}

