/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.jsword.JSOtherMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginUtil {
    public static final String EXTENSION_PLUGIN = ".plugin";
    private static final String DEFAULT = "default";
    private static final Logger log = LoggerFactory.getLogger(PluginUtil.class);

    private PluginUtil() {
    }

    public static <T> Class<T>[] getImplementors(Class<T> clazz) {
        try {
            ArrayList matches = new ArrayList();
            PropertyMap props = PluginUtil.getPlugin(clazz);
            for (String key : props.keySet()) {
                String name = props.get(key);
                try {
                    Class<?> impl = ClassUtil.forName(name);
                    if (clazz.isAssignableFrom(impl)) {
                        matches.add(impl);
                        continue;
                    }
                    log.warn("Class {} does not implement {}. Ignoring.", (Object)impl.getName(), (Object)clazz.getName());
                }
                catch (ClassNotFoundException ex) {
                    log.warn("Failed to add class to list: {}", (Object)clazz.getName(), (Object)ex);
                }
            }
            log.debug("Found {} implementors of {}", (Object)Integer.toString(matches.size()), (Object)clazz.getName());
            return matches.toArray(new Class[matches.size()]);
        }
        catch (IOException ex) {
            log.error("Failed to get any classes.", (Throwable)ex);
            return new Class[0];
        }
    }

    public static <T> Map<String, Class<T>> getImplementorsMap(Class<T> clazz) {
        HashMap<String, Class<T>> matches = new HashMap<String, Class<T>>();
        try {
            PropertyMap props = PluginUtil.getPlugin(clazz);
            for (String key : props.keySet()) {
                try {
                    String value = props.get(key);
                    Class<?> impl = ClassUtil.forName(value);
                    if (clazz.isAssignableFrom(impl)) {
                        matches.put(key, impl);
                        continue;
                    }
                    log.warn("Class {} does not implement {}. Ignoring.", (Object)impl.getName(), (Object)clazz.getName());
                }
                catch (ClassNotFoundException ex) {
                    log.warn("Failed to add class to list: {}", (Object)clazz.getName(), (Object)ex);
                }
            }
            log.debug("Found {} implementors of {}", (Object)Integer.toString(matches.size()), (Object)clazz.getName());
        }
        catch (IOException ex) {
            log.error("Failed to get any classes.", (Throwable)ex);
        }
        return matches;
    }

    public static <T> Class<T> getImplementor(Class<T> clazz) throws IOException, ClassNotFoundException, ClassCastException {
        PropertyMap props = PluginUtil.getPlugin(clazz);
        String name = props.get(DEFAULT);
        Class<?> impl = ClassUtil.forName(name);
        if (!clazz.isAssignableFrom(impl)) {
            throw new ClassCastException(JSOtherMsg.lookupText("Class {0} does not implement {1}.", impl.getName(), clazz.getName()));
        }
        return impl;
    }

    public static <T> T getImplementation(Class<T> clazz) throws MalformedURLException, ClassCastException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return PluginUtil.getImplementor(clazz).newInstance();
    }

    public static <T> PropertyMap getPlugin(Class<T> clazz) throws IOException {
        String subject = ClassUtil.getShortClassName(clazz);
        try {
            String lookup = subject + EXTENSION_PLUGIN;
            InputStream in = ResourceUtil.getResourceAsStream(clazz, lookup);
            PropertyMap prop = new PropertyMap();
            prop.load(in);
            return prop;
        }
        catch (MissingResourceException e) {
            return new PropertyMap();
        }
    }
}

