/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.versification.Versification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistinctPassage
extends AbstractPassage {
    private static final long serialVersionUID = 817374460730441662L;
    private transient SortedSet<Key> store = new TreeSet<Key>();

    public DistinctPassage(Versification v11n) {
        super(v11n);
    }

    protected DistinctPassage(Versification v11n, String refs, Key basis) throws NoSuchVerseException {
        super(v11n, refs);
        this.store = Collections.synchronizedSortedSet(new TreeSet());
        this.addVerses(refs, basis);
    }

    protected DistinctPassage(Versification v11n, String refs) throws NoSuchVerseException {
        this(v11n, refs, null);
    }

    @Override
    public DistinctPassage clone() {
        DistinctPassage copy = (DistinctPassage)super.clone();
        copy.store = new TreeSet<Key>();
        copy.store.addAll(this.store);
        return copy;
    }

    @Override
    public Iterator<Key> iterator() {
        return this.store.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    @Override
    public int countVerses() {
        return this.store.size();
    }

    @Override
    public boolean contains(Key obj) {
        for (Key aKey : obj) {
            if (this.store.contains(aKey)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(Key obj) {
        this.optimizeWrites();
        Verse firstVerse = null;
        Verse lastVerse = null;
        for (Key aKey : obj) {
            lastVerse = (Verse)aKey;
            if (firstVerse == null) {
                firstVerse = lastVerse;
            }
            this.store.add(lastVerse);
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalAdded(this, firstVerse, lastVerse);
        }
    }

    @Override
    public void remove(Key obj) {
        this.optimizeWrites();
        Verse firstVerse = null;
        Verse lastVerse = null;
        for (Key aKey : obj) {
            lastVerse = (Verse)aKey;
            if (firstVerse == null) {
                firstVerse = lastVerse;
            }
            this.store.remove(lastVerse);
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalAdded(this, firstVerse, lastVerse);
        }
    }

    @Override
    public void clear() {
        this.optimizeWrites();
        this.store.clear();
        this.fireIntervalRemoved(this, null, null);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeObjectSupport(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.optimizeWrites();
        this.store = new TreeSet<Key>();
        in.defaultReadObject();
        this.readObjectSupport(in);
    }
}

