/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword.state;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.sword.BlockType;
import org.crosswire.jsword.book.sword.state.GenBookBackendState;
import org.crosswire.jsword.book.sword.state.OpenFileState;
import org.crosswire.jsword.book.sword.state.RawBackendState;
import org.crosswire.jsword.book.sword.state.RawFileBackendState;
import org.crosswire.jsword.book.sword.state.RawLDBackendState;
import org.crosswire.jsword.book.sword.state.ZLDBackendState;
import org.crosswire.jsword.book.sword.state.ZVerseBackendState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenFileStateManager {
    private final ScheduledFuture<?> monitoringThread;
    private final Map<BookMetaData, Queue<OpenFileState>> metaToStates = new HashMap<BookMetaData, Queue<OpenFileState>>();
    private volatile boolean shuttingDown;
    private static volatile OpenFileStateManager manager;
    private static final Logger LOGGER;

    private OpenFileStateManager(int cleanupIntervalSeconds, final int maxExpiry) {
        this.monitoringThread = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        }).scheduleWithFixedDelay(new Runnable(){

            public void run() {
                long currentTime = System.currentTimeMillis();
                for (Queue e : OpenFileStateManager.this.metaToStates.values()) {
                    Iterator iterator = e.iterator();
                    while (iterator.hasNext()) {
                        OpenFileState state = (OpenFileState)iterator.next();
                        if (state.getLastAccess() + (long)(maxExpiry * 1000) >= currentTime) continue;
                        state.releaseResources();
                        iterator.remove();
                    }
                }
            }
        }, 0L, cleanupIntervalSeconds, TimeUnit.SECONDS);
    }

    public static synchronized void init(int cleanupIntervalSeconds, int maxExpiry) {
        if (manager == null) {
            manager = new OpenFileStateManager(cleanupIntervalSeconds, maxExpiry);
        } else {
            LOGGER.warn("The OpenFileStateManager has already been initialised, potentially with its default settings. The following values were ignored: cleanUpInterval [{}], maxExpiry=[{}]", (Object)Integer.toString(cleanupIntervalSeconds), (Object)Integer.toString(maxExpiry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenFileStateManager instance() {
        if (manager != null) return manager;
        Class<OpenFileStateManager> clazz = OpenFileStateManager.class;
        synchronized (OpenFileStateManager.class) {
            OpenFileStateManager.init(60, 60);
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public RawBackendState getRawBackendState(BookMetaData metadata) throws BookException {
        this.ensureNotShuttingDown();
        RawBackendState state = (RawBackendState)this.getInstance(metadata);
        if (state == null) {
            LOGGER.trace("Initializing: {}", (Object)metadata.getInitials());
            return new RawBackendState(metadata);
        }
        LOGGER.trace("Reusing: {}", (Object)metadata.getInitials());
        return state;
    }

    public RawFileBackendState getRawFileBackendState(BookMetaData metadata) throws BookException {
        this.ensureNotShuttingDown();
        RawFileBackendState state = (RawFileBackendState)this.getInstance(metadata);
        if (state == null) {
            LOGGER.trace("Initializing: {}", (Object)metadata.getInitials());
            return new RawFileBackendState(metadata);
        }
        LOGGER.trace("Reusing: {}", (Object)metadata.getInitials());
        return state;
    }

    public GenBookBackendState getGenBookBackendState(BookMetaData metadata) throws BookException {
        this.ensureNotShuttingDown();
        GenBookBackendState state = (GenBookBackendState)this.getInstance(metadata);
        if (state == null) {
            LOGGER.trace("Initializing: {}", (Object)metadata.getInitials());
            return new GenBookBackendState(metadata);
        }
        LOGGER.trace("Reusing: {}", (Object)metadata.getInitials());
        return state;
    }

    public RawLDBackendState getRawLDBackendState(BookMetaData metadata) throws BookException {
        this.ensureNotShuttingDown();
        RawLDBackendState state = (RawLDBackendState)this.getInstance(metadata);
        if (state == null) {
            LOGGER.trace("Initializing: {}", (Object)metadata.getInitials());
            return new RawLDBackendState(metadata);
        }
        LOGGER.trace("Reusing: {}", (Object)metadata.getInitials());
        return state;
    }

    public ZLDBackendState getZLDBackendState(BookMetaData metadata) throws BookException {
        this.ensureNotShuttingDown();
        ZLDBackendState state = (ZLDBackendState)this.getInstance(metadata);
        if (state == null) {
            LOGGER.trace("Initializing: {}", (Object)metadata.getInitials());
            return new ZLDBackendState(metadata);
        }
        LOGGER.trace("Reusing: {}", (Object)metadata.getInitials());
        return state;
    }

    public ZVerseBackendState getZVerseBackendState(BookMetaData metadata, BlockType blockType) throws BookException {
        this.ensureNotShuttingDown();
        ZVerseBackendState state = (ZVerseBackendState)this.getInstance(metadata);
        if (state == null) {
            LOGGER.trace("Initializing: {}", (Object)metadata.getInitials());
            return new ZVerseBackendState(metadata, blockType);
        }
        LOGGER.trace("Reusing: {}", (Object)metadata.getInitials());
        return state;
    }

    private <T extends OpenFileState> T getInstance(BookMetaData metadata) {
        Queue<OpenFileState> availableStates = this.getQueueForMeta(metadata);
        OpenFileState state = availableStates.poll();
        if (state != null) {
            state.setLastAccess(System.currentTimeMillis());
        }
        return (T)state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Queue<OpenFileState> getQueueForMeta(BookMetaData metadata) {
        Queue<OpenFileState> availableStates = this.metaToStates.get(metadata);
        if (availableStates != null) return availableStates;
        Class<OpenFileState> clazz = OpenFileState.class;
        synchronized (OpenFileState.class) {
            availableStates = new ConcurrentLinkedQueue<OpenFileState>();
            this.metaToStates.put(metadata, availableStates);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return availableStates;
        }
    }

    public void release(OpenFileState fileState) {
        if (fileState == null) {
            return;
        }
        fileState.setLastAccess(System.currentTimeMillis());
        BookMetaData bmd = fileState.getBookMetaData();
        Queue<OpenFileState> queueForMeta = this.getQueueForMeta(bmd);
        LOGGER.trace("Offering to releasing: {}", (Object)bmd.getInitials());
        boolean offered = queueForMeta.offer(fileState);
        if (!offered) {
            LOGGER.trace("Released: {}", (Object)bmd.getInitials());
            fileState.releaseResources();
        }
    }

    public void shutDown() {
        this.shuttingDown = true;
        this.monitoringThread.cancel(true);
        for (Queue<OpenFileState> e : this.metaToStates.values()) {
            OpenFileState state = null;
            while ((state = e.poll()) != null) {
                state.releaseResources();
            }
        }
    }

    private void ensureNotShuttingDown() throws BookException {
        if (this.shuttingDown) {
            throw new BookException("Unable to read book, application is shutting down.");
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(OpenFileStateManager.class);
    }
}

