/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.DataIndex;
import org.crosswire.jsword.book.sword.RawBackend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.state.OpenFileStateManager;
import org.crosswire.jsword.book.sword.state.RawBackendState;
import org.crosswire.jsword.book.sword.state.RawFileBackendState;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.versification.Testament;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawFileBackend
extends RawBackend<RawFileBackendState> {
    private static final Logger log = LoggerFactory.getLogger(RawFileBackend.class);

    public RawFileBackend(SwordBookMetaData sbmd, int datasize) {
        super(sbmd, datasize);
    }

    @Override
    public RawFileBackendState initState() throws BookException {
        return OpenFileStateManager.instance().getRawFileBackendState(this.getBookMetaData());
    }

    @Override
    protected String getEntry(RawBackendState state, String name, Testament testament, long index) throws IOException {
        RandomAccessFile idxRaf = state.getIdxRaf(testament);
        RandomAccessFile txtRaf = state.getTextRaf(testament);
        DataIndex dataIndex = this.getIndex(idxRaf, index);
        int size = dataIndex.getSize();
        if (size == 0) {
            return "";
        }
        if (size < 0) {
            log.error("In {}: Verse {} has a bad index size of {}.", new Object[]{this.getBookMetaData().getInitials(), name, Integer.toString(size)});
            return "";
        }
        try {
            File dataFile = this.getDataTextFile(txtRaf, dataIndex);
            byte[] textBytes = this.readTextDataFile(dataFile);
            this.decipher(textBytes);
            return SwordUtil.decode(name, textBytes, this.getBookMetaData().getBookCharset());
        }
        catch (BookException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void setRawText(RawFileBackendState state, Key key, String text) throws BookException, IOException {
        File dataFile;
        String v11nName = this.getBookMetaData().getProperty("Versification");
        Versification v11n = Versifications.instance().getVersification(v11nName);
        Verse verse = KeyUtil.getVerse(key);
        int index = verse.getOrdinal();
        Testament testament = v11n.getTestament(index);
        index = v11n.getTestamentOrdinal(index);
        RandomAccessFile idxRaf = state.getIdxRaf(testament);
        RandomAccessFile txtRaf = state.getTextRaf(testament);
        File txtFile = state.getTextFile(testament);
        DataIndex dataIndex = this.getIndex(idxRaf, index);
        if (dataIndex.getSize() == 0) {
            dataFile = this.createDataTextFile(state.getIncfileValue());
            this.updateIndexFile(idxRaf, index, txtRaf.length());
            this.updateDataFile(state.getIncfileValue(), txtFile);
            this.checkAndIncrementIncfile(state, state.getIncfileValue());
        } else {
            dataFile = this.getDataTextFile(txtRaf, dataIndex);
        }
        byte[] textData = text.getBytes("UTF-8");
        this.encipher(textData);
        this.writeTextDataFile(dataFile, textData);
    }

    @Override
    public void setAliasKey(RawFileBackendState state, Key alias, Key source) throws IOException {
        String v11nName = this.getBookMetaData().getProperty("Versification");
        Versification v11n = Versifications.instance().getVersification(v11nName);
        Verse aliasVerse = KeyUtil.getVerse(alias);
        Verse sourceVerse = KeyUtil.getVerse(source);
        int aliasIndex = aliasVerse.getOrdinal();
        Testament testament = v11n.getTestament(aliasIndex);
        aliasIndex = v11n.getTestamentOrdinal(aliasIndex);
        RandomAccessFile idxRaf = state.getIdxRaf(testament);
        int sourceOIndex = sourceVerse.getOrdinal();
        sourceOIndex = v11n.getTestamentOrdinal(sourceOIndex);
        DataIndex dataIndex = this.getIndex(idxRaf, sourceOIndex);
        this.updateIndexFile(idxRaf, aliasIndex, dataIndex.getOffset());
    }

    private File createDataTextFile(int index) throws BookException, IOException {
        String dataPath = SwordUtil.getExpandedDataPath(this.getBookMetaData()).getPath();
        File dataFile = new File(dataPath = dataPath + File.separator + String.format("%07d", index));
        if (!dataFile.exists() && !dataFile.createNewFile()) {
            throw new IOException("Could not create data file.");
        }
        return dataFile;
    }

    private String getTextFilename(RandomAccessFile txtRaf, DataIndex dataIndex) throws IOException {
        byte[] data = SwordUtil.readRAF(txtRaf, dataIndex.getOffset(), dataIndex.getSize());
        this.decipher(data);
        if (data.length == 7) {
            return new String(data, 0, 7);
        }
        log.error("Read data is not of appropriate size of 9 bytes!");
        throw new IOException("Datalength is not 9 bytes!");
    }

    private File getDataTextFile(RandomAccessFile txtRaf, DataIndex dataIndex) throws IOException, BookException {
        String dataFilename = this.getTextFilename(txtRaf, dataIndex);
        String dataPath = SwordUtil.getExpandedDataPath(this.getBookMetaData()).getPath() + File.separator + dataFilename;
        return new File(dataPath);
    }

    protected void updateIndexFile(RandomAccessFile idxRaf, long index, long dataFileStartPosition) throws IOException {
        long indexFileWriteOffset = index * (long)this.entrysize;
        int dataFileLengthValue = 7;
        byte[] startPositionData = this.littleEndian32BitByteArrayFromInt((int)dataFileStartPosition);
        byte[] lengthValueData = this.littleEndian16BitByteArrayFromShort((short)dataFileLengthValue);
        byte[] indexFileWriteData = new byte[]{startPositionData[0], startPositionData[1], startPositionData[2], startPositionData[3], lengthValueData[0], lengthValueData[1]};
        SwordUtil.writeRAF(idxRaf, indexFileWriteOffset, indexFileWriteData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDataFile(long ordinal, File txtFile) throws IOException {
        String fileName = String.format("%07d\r\n", ordinal);
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(txtFile, true));
            bos.write(fileName.getBytes(this.getBookMetaData().getBookCharset()));
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
    }

    private void checkAndIncrementIncfile(RawFileBackendState state, int index) throws IOException {
        if (index >= state.getIncfileValue()) {
            int incValue = index + 1;
            state.setIncfileValue(incValue);
            this.writeIncfile(state, incValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws IOException, BookException {
        super.create();
        this.createDataFiles();
        this.createIndexFiles();
        RawFileBackendState state = null;
        try {
            state = this.initState();
            this.createIncfile(state);
            this.prepopulateIndexFiles(state);
            this.prepopulateIncfile(state);
        }
        finally {
            OpenFileStateManager.instance().release(state);
        }
    }

    private void createDataFiles() throws IOException, BookException {
        String path = SwordUtil.getExpandedDataPath(this.getBookMetaData()).getPath();
        File otTextFile = new File(path + File.separator + "ot");
        if (!otTextFile.exists() && !otTextFile.createNewFile()) {
            throw new IOException("Could not create ot text file.");
        }
        File ntTextFile = new File(path + File.separator + "nt");
        if (!ntTextFile.exists() && !ntTextFile.createNewFile()) {
            throw new IOException("Could not create nt text file.");
        }
    }

    private void createIndexFiles() throws IOException, BookException {
        String path = SwordUtil.getExpandedDataPath(this.getBookMetaData()).getPath();
        File otIndexFile = new File(path + File.separator + "ot" + ".vss");
        if (!otIndexFile.exists() && !otIndexFile.createNewFile()) {
            throw new IOException("Could not create ot index file.");
        }
        File ntIndexFile = new File(path + File.separator + "nt" + ".vss");
        if (!ntIndexFile.exists() && !ntIndexFile.createNewFile()) {
            throw new IOException("Could not create nt index file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepopulateIndexFiles(RawFileBackendState state) throws IOException {
        String v11nName = this.getBookMetaData().getProperty("Versification");
        Versification v11n = Versifications.instance().getVersification(v11nName);
        int otCount = v11n.getCount(Testament.OLD);
        int ntCount = v11n.getCount(Testament.NEW) + 1;
        BufferedOutputStream otIdxBos = new BufferedOutputStream(new FileOutputStream(state.getIdxFile(Testament.OLD), false));
        try {
            for (int i = 0; i < otCount; ++i) {
                this.writeInitialIndex(otIdxBos);
            }
        }
        finally {
            otIdxBos.close();
        }
        BufferedOutputStream ntIdxBos = new BufferedOutputStream(new FileOutputStream(state.getIdxFile(Testament.NEW), false));
        try {
            for (int i = 0; i < ntCount; ++i) {
                this.writeInitialIndex(ntIdxBos);
            }
        }
        finally {
            ntIdxBos.close();
        }
    }

    private void createIncfile(RawFileBackendState state) throws IOException, BookException {
        File tempIncfile = new File(SwordUtil.getExpandedDataPath(this.getBookMetaData()).getPath() + File.separator + "incfile");
        if (!tempIncfile.exists() && !tempIncfile.createNewFile()) {
            throw new IOException("Could not create incfile file.");
        }
        state.setIncfile(tempIncfile);
    }

    private void prepopulateIncfile(RawFileBackendState state) throws IOException {
        this.writeIncfile(state, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIncfile(RawFileBackendState state, int value) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(state.getIncfile(), false);
            fos.write(this.littleEndian32BitByteArrayFromInt(value));
        }
        catch (FileNotFoundException e) {
            log.error("Error on writing to incfile, file should exist already!", (Throwable)e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void writeInitialIndex(BufferedOutputStream outStream) throws IOException {
        outStream.write(this.littleEndian32BitByteArrayFromInt(0));
        outStream.write(this.littleEndian16BitByteArrayFromShort((short)0));
    }

    private byte[] readTextDataFile(File dataFile) throws IOException {
        BufferedInputStream inStream = null;
        try {
            int len = (int)dataFile.length();
            byte[] textData = new byte[len];
            inStream = new BufferedInputStream(new FileInputStream(dataFile));
            if (inStream.read(textData) != len) {
                log.error("Read data is not of appropriate size of {} bytes!", (Object)Integer.toString(len));
                throw new IOException("data is not " + len + " bytes long");
            }
            byte[] byArray = textData;
            return byArray;
        }
        catch (FileNotFoundException ex) {
            log.error("Could not read text data file, file not found: {}", (Object)dataFile.getName(), (Object)ex);
            throw ex;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTextDataFile(File dataFile, byte[] textData) throws IOException {
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(dataFile, false));
            bos.write(textData);
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
    }

    private byte[] littleEndian32BitByteArrayFromInt(int val) {
        byte[] buffer = new byte[4];
        SwordUtil.encodeLittleEndian32(val, buffer, 0);
        return buffer;
    }

    private byte[] littleEndian16BitByteArrayFromShort(short val) {
        byte[] buffer = new byte[2];
        SwordUtil.encodeLittleEndian16(val, buffer, 0);
        return buffer;
    }
}

