/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.DataIndex;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.state.OpenFileState;
import org.crosswire.jsword.book.sword.state.OpenFileStateManager;
import org.crosswire.jsword.book.sword.state.RawBackendState;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.RocketPassage;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.versification.Testament;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawBackend<T extends RawBackendState>
extends AbstractBackend<RawBackendState> {
    protected final int datasize;
    protected final int entrysize;
    protected static final int OFFSETSIZE = 4;
    private static final Logger log = LoggerFactory.getLogger(RawBackend.class);

    public RawBackend(SwordBookMetaData sbmd, int datasize) {
        super(sbmd);
        this.datasize = datasize;
        this.entrysize = 4 + datasize;
        assert (datasize == 2 || datasize == 4);
    }

    @Override
    public boolean contains(Key key) {
        return this.getRawTextLength(key) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int getRawTextLength(Key key) {
        int n;
        String v11nName = this.getBookMetaData().getProperty("Versification");
        Versification v11n = Versifications.instance().getVersification(v11nName);
        Verse verse = KeyUtil.getVerse(key);
        OpenFileState initState = null;
        try {
            int index = verse.getOrdinal();
            Testament testament = v11n.getTestament(index);
            index = v11n.getTestamentOrdinal(index);
            initState = this.initState();
            RandomAccessFile idxRaf = ((RawBackendState)initState).getIdxRaf(testament);
            if (idxRaf == null) {
                int n2 = 0;
                OpenFileStateManager.instance().release(initState);
                return n2;
            }
            DataIndex dataIndex = this.getIndex(idxRaf, index);
            n = dataIndex.getSize();
            OpenFileStateManager.instance().release(initState);
        }
        catch (IOException ex) {
            int n3 = 0;
            return n3;
        }
        catch (BookException e) {
            int n4 = 0;
            return n4;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            OpenFileStateManager.instance().release(initState);
        }
        return n;
    }

    @Override
    public Key getGlobalKeyList() throws BookException {
        OpenFileState rafBook = null;
        try {
            rafBook = this.initState();
            String v11nName = this.getBookMetaData().getProperty("Versification");
            Versification v11n = Versifications.instance().getVersification(v11nName);
            Testament[] testaments = new Testament[]{Testament.OLD, Testament.NEW};
            RocketPassage passage = new RocketPassage(v11n);
            passage.raiseEventSuppresion();
            passage.raiseNormalizeProtection();
            for (Testament currentTestament : testaments) {
                int ordinal;
                int ii;
                RandomAccessFile idxRaf = ((RawBackendState)rafBook).getIdxRaf(currentTestament);
                if (idxRaf == null) continue;
                int maxIndex = v11n.getCount(currentTestament) - 1;
                byte[] temp = SwordUtil.readRAF(idxRaf, 0L, this.entrysize * maxIndex);
                if (this.datasize == 2) {
                    for (ii = 0; ii < temp.length; ii += this.entrysize) {
                        if (temp[ii + 4] == 0 && temp[ii + 5] == 0) continue;
                        ordinal = ii / this.entrysize;
                        passage.addVersifiedOrdinal(v11n.getOrdinal(currentTestament, ordinal));
                    }
                    continue;
                }
                for (ii = 0; ii < temp.length; ii += this.entrysize) {
                    if (temp[ii + 4] == 0 && temp[ii + 5] == 0 && temp[ii + 6] == 0 && temp[ii + 7] == 0) continue;
                    ordinal = ii / this.entrysize;
                    passage.addVersifiedOrdinal(v11n.getOrdinal(currentTestament, ordinal));
                }
            }
            passage.lowerNormalizeProtection();
            passage.lowerEventSuppressionAndTest();
            RocketPassage rocketPassage = passage;
            return rocketPassage;
        }
        catch (IOException e) {
            throw new BookException(JSMsg.gettext("Unable to read key list from book.", new Object[0]));
        }
        finally {
            OpenFileStateManager.instance().release(rafBook);
        }
    }

    @Override
    public T initState() throws BookException {
        return (T)OpenFileStateManager.instance().getRawBackendState(this.getBookMetaData());
    }

    public String getRawText(RawBackendState state, Key key) throws IOException {
        return this.readRawContent(state, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readRawContent(RawBackendState state, Key key) throws IOException {
        String v11nName = this.getBookMetaData().getProperty("Versification");
        Versification v11n = Versifications.instance().getVersification(v11nName);
        Verse verse = KeyUtil.getVerse(key);
        int index = verse.getOrdinal();
        Testament testament = v11n.getTestament(index);
        index = v11n.getTestamentOrdinal(index);
        OpenFileState initState = null;
        try {
            initState = this.initState();
            String string = this.getEntry(state, verse.getName(), testament, index);
            return string;
        }
        catch (BookException e) {
            String string = "";
            return string;
        }
        finally {
            OpenFileStateManager.instance().release(initState);
        }
    }

    @Override
    public void setRawText(RawBackendState state, Key key, String text) throws BookException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWritable() {
        OpenFileState rawBackendState = null;
        try {
            rawBackendState = this.initState();
            boolean bl = ((RawBackendState)rawBackendState).isWritable();
            return bl;
        }
        catch (BookException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            OpenFileStateManager.instance().release(rawBackendState);
        }
    }

    @Override
    public void setAliasKey(RawBackendState state, Key alias, Key source) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected DataIndex getIndex(RandomAccessFile raf, long entry) throws IOException {
        byte[] buffer = SwordUtil.readRAF(raf, entry * (long)this.entrysize, this.entrysize);
        if (buffer == null || buffer.length == 0) {
            return new DataIndex(0, 0);
        }
        int entryOffset = SwordUtil.decodeLittleEndian32(buffer, 0);
        int entrySize = -1;
        switch (this.datasize) {
            case 2: {
                entrySize = SwordUtil.decodeLittleEndian16(buffer, 4);
                break;
            }
            case 4: {
                entrySize = SwordUtil.decodeLittleEndian32(buffer, 4);
                break;
            }
            default: {
                assert (false) : this.datasize;
                break;
            }
        }
        return new DataIndex(entryOffset, entrySize);
    }

    protected String getEntry(RawBackendState state, String name, Testament testament, long index) throws IOException {
        RandomAccessFile idxRaf = state.getIdxRaf(testament);
        RandomAccessFile txtRaf = state.getTextRaf(testament);
        if (idxRaf == null) {
            return "";
        }
        DataIndex dataIndex = this.getIndex(idxRaf, index);
        int size = dataIndex.getSize();
        if (size == 0) {
            return "";
        }
        if (size < 0) {
            log.error("In {}: Verse {} has a bad index size of {}", new Object[]{this.getBookMetaData().getInitials(), name, Integer.toString(size)});
            return "";
        }
        byte[] data = SwordUtil.readRAF(txtRaf, dataIndex.getOffset(), size);
        this.decipher(data);
        return SwordUtil.decode(name, data, this.getBookMetaData().getBookCharset());
    }
}

