/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.Map;
import java.util.TreeMap;
import org.crosswire.common.config.ChoiceFactory;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookComparators;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.DefaultBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Defaults {
    private static final String BIBLE_KEY = "bible-names";
    private static final String COMMENTARY_KEY = "commentary-names";
    private static final String DICTIONARY_KEY = "dictionary-names";
    private static final String DAILY_DEVOTIONALS_KEY = "daily-devotional-names";
    private static final String GREEKDEF_KEY = "greekdef-names";
    private static final String HEBREWDEF_KEY = "hebrewdef-names";
    private static final String GREEKPARSE_KEY = "greekparse-names";
    private static final String HEBREWPARSE_KEY = "hebrewparse-names";
    private static boolean trackBible = true;
    private static Book currentBible;
    private static DefaultBook bibleDeft;
    private static DefaultBook commentaryDeft;
    private static DefaultBook dailyDevotionalDeft;
    private static DefaultBook dictionaryDeft;
    private static DefaultBook greekParseDeft;
    private static DefaultBook hebrewParseDeft;
    private static DefaultBook greekDefinitionsDeft;
    private static DefaultBook hebrewDefinitionsDeft;

    private Defaults() {
    }

    public static boolean isCurrentBible() {
        return trackBible;
    }

    public static void setCurrentBible(boolean current) {
        trackBible = current;
    }

    public static void setCurrentBook(Book book) {
        BookCategory type = book.getBookCategory();
        if (type.equals((Object)BookCategory.BIBLE) && Defaults.isCurrentBible()) {
            currentBible = book;
        }
    }

    public static Book getCurrentBible() {
        if (currentBible == null) {
            return bibleDeft.getDefault();
        }
        return currentBible;
    }

    public static void setBible(Book book) {
        bibleDeft.setDefault(book);
    }

    protected static void unsetBible() {
        bibleDeft.unsetDefault();
    }

    public static Book getBible() {
        return bibleDeft.getDefault();
    }

    public static String getBibleByName() {
        return bibleDeft.getDefaultName();
    }

    public static void setBibleByName(String name) {
        bibleDeft.setDefaultByName(name);
    }

    public static void setCommentary(Book book) {
        commentaryDeft.setDefault(book);
    }

    protected static void unsetCommentary() {
        commentaryDeft.unsetDefault();
    }

    public static Book getCommentary() {
        return commentaryDeft.getDefault();
    }

    public static String getCommentaryByName() {
        return commentaryDeft.getDefaultName();
    }

    public static void setCommentaryByName(String name) {
        commentaryDeft.setDefaultByName(name);
    }

    public static void setDictionary(Book book) {
        dictionaryDeft.setDefault(book);
    }

    protected static void unsetDictionary() {
        dictionaryDeft.unsetDefault();
    }

    public static Book getDictionary() {
        return dictionaryDeft.getDefault();
    }

    public static String getDictionaryByName() {
        return dictionaryDeft.getDefaultName();
    }

    public static void setDictionaryByName(String name) {
        dictionaryDeft.setDefaultByName(name);
    }

    public static void setDailyDevotional(Book book) {
        dictionaryDeft.setDefault(book);
    }

    protected static void unsetDailyDevotional() {
        dailyDevotionalDeft.unsetDefault();
    }

    public static Book getDailyDevotional() {
        return dailyDevotionalDeft.getDefault();
    }

    public static String getDailyDevotionalByName() {
        return dailyDevotionalDeft.getDefaultName();
    }

    public static void setDailyDevotionalByName(String name) {
        dailyDevotionalDeft.setDefaultByName(name);
    }

    public static void setGreekDefinitions(Book book) {
        greekDefinitionsDeft.setDefault(book);
    }

    protected static void unsetGreekDefinitions() {
        greekDefinitionsDeft.unsetDefault();
    }

    public static Book getGreekDefinitions() {
        return greekDefinitionsDeft.getDefault();
    }

    public static String getGreekDefinitionsByName() {
        return greekDefinitionsDeft.getDefaultName();
    }

    public static void setGreekDefinitionsByName(String name) {
        greekDefinitionsDeft.setDefaultByName(name);
    }

    public static void setHebrewDefinitions(Book book) {
        hebrewDefinitionsDeft.setDefault(book);
    }

    protected static void unsetHebrewDefinitions() {
        hebrewDefinitionsDeft.unsetDefault();
    }

    public static Book getHebrewDefinitions() {
        return hebrewDefinitionsDeft.getDefault();
    }

    public static String getHebrewDefinitionsByName() {
        return hebrewDefinitionsDeft.getDefaultName();
    }

    public static void setHebrewDefinitionsByName(String name) {
        hebrewDefinitionsDeft.setDefaultByName(name);
    }

    public static void setGreekParse(Book book) {
        greekParseDeft.setDefault(book);
    }

    protected static void unsetGreekParse() {
        greekParseDeft.unsetDefault();
    }

    public static Book getGreekParse() {
        return greekParseDeft.getDefault();
    }

    public static String getGreekParseByName() {
        return greekParseDeft.getDefaultName();
    }

    public static void setGreekParseByName(String name) {
        greekParseDeft.setDefaultByName(name);
    }

    public static void setHebrewParse(Book book) {
        hebrewParseDeft.setDefault(book);
    }

    protected static void unsetHebrewParse() {
        hebrewParseDeft.unsetDefault();
    }

    public static Book getHebrewParse() {
        return hebrewParseDeft.getDefault();
    }

    public static String getHebrewParseByName() {
        return hebrewParseDeft.getDefaultName();
    }

    public static void setHebrewParseByName(String name) {
        hebrewParseDeft.setDefaultByName(name);
    }

    protected static DefaultBook getDefaultBible() {
        return bibleDeft;
    }

    protected static DefaultBook getDefaultCommentary() {
        return commentaryDeft;
    }

    protected static DefaultBook getDefaultDictionary() {
        return dictionaryDeft;
    }

    protected static DefaultBook getDefaultDailyDevotional() {
        return dailyDevotionalDeft;
    }

    protected static DefaultBook getDefaultGreekDefinitions() {
        return greekDefinitionsDeft;
    }

    protected static DefaultBook getDefaultHebrewDefinitions() {
        return hebrewDefinitionsDeft;
    }

    protected static DefaultBook getDefaultGreekParse() {
        return greekParseDeft;
    }

    protected static DefaultBook getDefaultHebrewParse() {
        return hebrewParseDeft;
    }

    public static void refreshBooks() {
        Map<Book, String> bnames = Defaults.getBookMap(BookFilters.getOnlyBibles());
        ChoiceFactory.getDataMap().put(BIBLE_KEY, bnames);
        Map<Book, String> cnames = Defaults.getBookMap(BookFilters.getCommentaries());
        ChoiceFactory.getDataMap().put(COMMENTARY_KEY, cnames);
        Map<Book, String> dnames = Defaults.getBookMap(BookFilters.getDictionaries());
        ChoiceFactory.getDataMap().put(DICTIONARY_KEY, dnames);
        Map<Book, String> rnames = Defaults.getBookMap(BookFilters.getDailyDevotionals());
        ChoiceFactory.getDataMap().put(DAILY_DEVOTIONALS_KEY, rnames);
        Map<Book, String> greekDef = Defaults.getBookMap(BookFilters.getGreekDefinitions());
        ChoiceFactory.getDataMap().put(GREEKDEF_KEY, greekDef);
        Map<Book, String> hebrewDef = Defaults.getBookMap(BookFilters.getHebrewDefinitions());
        ChoiceFactory.getDataMap().put(HEBREWDEF_KEY, hebrewDef);
        Map<Book, String> greekParse = Defaults.getBookMap(BookFilters.getGreekParse());
        ChoiceFactory.getDataMap().put(GREEKPARSE_KEY, greekParse);
        Map<Book, String> hebrewParse = Defaults.getBookMap(BookFilters.getHebrewParse());
        ChoiceFactory.getDataMap().put(HEBREWPARSE_KEY, hebrewParse);
    }

    protected static void checkAllPreferable() {
        for (Book book : Books.installed().getBooks()) {
            Defaults.checkPreferable(book);
        }
    }

    protected static void checkPreferable(Book book) {
        assert (book != null);
        bibleDeft.setDefaultConditionally(book);
        commentaryDeft.setDefaultConditionally(book);
        dictionaryDeft.setDefaultConditionally(book);
        dailyDevotionalDeft.setDefaultConditionally(book);
        greekDefinitionsDeft.setDefaultConditionally(book);
        greekParseDeft.setDefaultConditionally(book);
        hebrewDefinitionsDeft.setDefaultConditionally(book);
        hebrewParseDeft.setDefaultConditionally(book);
    }

    private static Map<Book, String> getBookMap(BookFilter filter) {
        TreeMap<Book, String> books = new TreeMap<Book, String>(BookComparators.getDefault());
        for (Book book : Books.installed().getBooks(filter)) {
            books.put(book, book.getName());
        }
        return books;
    }

    static {
        bibleDeft = new DefaultBook(Books.installed(), BookFilters.getOnlyBibles());
        commentaryDeft = new DefaultBook(Books.installed(), BookFilters.getCommentaries());
        dailyDevotionalDeft = new DefaultBook(Books.installed(), BookFilters.getDailyDevotionals());
        dictionaryDeft = new DefaultBook(Books.installed(), BookFilters.getDictionaries());
        greekParseDeft = new DefaultBook(Books.installed(), BookFilters.getGreekParse());
        hebrewParseDeft = new DefaultBook(Books.installed(), BookFilters.getHebrewParse());
        greekDefinitionsDeft = new DefaultBook(Books.installed(), BookFilters.getGreekDefinitions());
        hebrewDefinitionsDeft = new DefaultBook(Books.installed(), BookFilters.getHebrewDefinitions());
        Books.installed().addBooksListener(new DefaultsBookListener());
        Defaults.checkAllPreferable();
    }

    static class DefaultsBookListener
    implements BooksListener {
        DefaultsBookListener() {
        }

        public void bookAdded(BooksEvent ev) {
            Book book = ev.getBook();
            Defaults.checkPreferable(book);
            Defaults.refreshBooks();
        }

        public void bookRemoved(BooksEvent ev) {
            Book book = ev.getBook();
            Defaults.getDefaultBible().unsetDefaultConditionally(book);
            Defaults.getDefaultCommentary().unsetDefaultConditionally(book);
            Defaults.getDefaultDailyDevotional().unsetDefaultConditionally(book);
            Defaults.getDefaultDictionary().unsetDefaultConditionally(book);
            Defaults.getDefaultGreekDefinitions().unsetDefaultConditionally(book);
            Defaults.getDefaultGreekParse().unsetDefaultConditionally(book);
            Defaults.getDefaultHebrewDefinitions().unsetDefaultConditionally(book);
            Defaults.getDefaultHebrewParse().unsetDefaultConditionally(book);
        }
    }
}

