/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.diff;

import java.util.HashMap;
import java.util.Map;
import org.crosswire.common.diff.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bitap
implements Locator {
    private static final int MAXBITS = 32;
    private static final float BALANCE = 0.5f;
    private static float balance = 0.5f;
    private static final float THRESHOLD = 0.5f;
    private static float threshold = 0.5f;
    private static final int MINLENGTH = 100;
    private static int minLength = 100;
    private static final int MAXLENGTH = 1000;
    private static int maxLength = 1000;
    private String text;
    private String pattern;
    private int loc;
    private int scoreTextLength;
    private Map<Character, Integer> alphabet;

    public Bitap(String text, String pattern, int loc) {
        this.text = text;
        this.pattern = pattern;
        this.loc = loc;
        this.alphabet = new HashMap<Character, Integer>();
    }

    @Override
    public int maxPatternLength() {
        return 32;
    }

    @Override
    public int locate() {
        this.alphabet();
        this.scoreTextLength = Math.max(this.text.length(), minLength);
        this.scoreTextLength = Math.min(this.scoreTextLength, maxLength);
        double scoreThreshold = threshold;
        int bestLoc = this.text.indexOf(this.pattern, this.loc);
        if (bestLoc != -1) {
            scoreThreshold = Math.min(this.bitapScore(0, bestLoc), scoreThreshold);
        }
        if ((bestLoc = this.text.lastIndexOf(this.pattern, this.loc + this.pattern.length())) != -1) {
            scoreThreshold = Math.min(this.bitapScore(0, bestLoc), scoreThreshold);
        }
        int matchmask = (int)Math.pow(2.0, this.pattern.length() - 1);
        bestLoc = -1;
        int binMax = Math.max(this.loc + this.loc, this.text.length());
        int[] lastrd = new int[]{};
        for (int d = 0; d < this.pattern.length(); ++d) {
            int[] rd = new int[this.text.length()];
            int binMin = this.loc;
            int binMid = binMax;
            while (binMin < binMid) {
                if (this.bitapScore(d, binMid) < scoreThreshold) {
                    binMin = binMid;
                } else {
                    binMax = binMid;
                }
                binMid = (binMax - binMin) / 2 + binMin;
            }
            binMax = binMid;
            int start = Math.max(0, this.loc - (binMid - this.loc) - 1);
            int finish = Math.min(this.text.length() - 1, this.pattern.length() + binMid);
            rd[finish] = this.text.charAt(finish) == this.pattern.charAt(this.pattern.length() - 1) ? (int)Math.pow(2.0, d + 1) - 1 : (int)Math.pow(2.0, d) - 1;
            for (int j = finish - 1; j >= start; --j) {
                double score;
                Character curChar = Character.valueOf(this.text.charAt(j));
                int mask = this.alphabet.containsKey(curChar) ? this.alphabet.get(curChar) : 0;
                rd[j] = d == 0 ? (rd[j + 1] << 1 | 1) & mask : (rd[j + 1] << 1 | 1) & mask | (lastrd[j + 1] << 1 | 1) | (lastrd[j] << 1 | 1) | lastrd[j + 1];
                if ((rd[j] & matchmask) == 0 || !((score = this.bitapScore(d, j)) <= scoreThreshold)) continue;
                scoreThreshold = score;
                bestLoc = j;
                if (j <= this.loc) break;
                start = Math.max(0, this.loc - (j - this.loc));
            }
            if (this.bitapScore(d + 1, this.loc) > scoreThreshold) break;
            lastrd = rd;
        }
        return bestLoc;
    }

    protected Map<Character, Integer> getAlphabet() {
        return this.alphabet;
    }

    private double bitapScore(int e, int x) {
        int d = Math.abs(this.loc - x);
        return (double)((float)e / (float)this.pattern.length() / balance) + (double)((float)d / (float)this.scoreTextLength) / (1.0 - (double)balance);
    }

    protected void alphabet() {
        int len = this.pattern.length();
        assert (len <= 32) : "Pattern too long for this application.";
        for (int i = 0; i < len; ++i) {
            Character c = Character.valueOf(this.pattern.charAt(i));
            Integer value = this.alphabet.get(c);
            int mask = value == null ? 0 : value;
            this.alphabet.put(c, mask |= (int)Math.pow(2.0, len - i - 1));
        }
    }

    public static void setBalance(float newBalance) {
        balance = newBalance;
    }

    public static void setThreshold(float newThreshold) {
        threshold = newThreshold;
    }

    public static void setMinLength(int newMinLength) {
        minLength = newMinLength;
    }

    public static void setMaxLength(int newMaxLength) {
        maxLength = newMaxLength;
    }
}

