/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.net.URI;
import org.crosswire.common.util.Language;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.KeyType;
import org.crosswire.jsword.index.IndexStatus;
import org.jdom2.Document;

public abstract class AbstractBookMetaData
implements BookMetaData {
    private BookDriver driver;
    private IndexStatus indexStatus = IndexStatus.UNDONE;
    private Language language;
    private URI library;
    private URI location;

    @Override
    public KeyType getKeyType() {
        return KeyType.LIST;
    }

    @Override
    public BookDriver getDriver() {
        return this.driver;
    }

    @Override
    public String getDriverName() {
        if (this.getDriver() == null) {
            return null;
        }
        return this.getDriver().getDriverName();
    }

    @Override
    public boolean hasFeature(FeatureType feature) {
        return false;
    }

    @Override
    public String getOsisID() {
        return this.getBookCategory().getName() + '.' + this.getInitials();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public boolean isEnciphered() {
        return false;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public boolean unlock(String unlockKey) {
        return false;
    }

    @Override
    public String getUnlockKey() {
        return null;
    }

    @Override
    public boolean isQuestionable() {
        return false;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(Language language) {
        this.language = language;
    }

    @Override
    public URI getLibrary() {
        return this.library;
    }

    @Override
    public void setLibrary(URI library) throws BookException {
        this.library = library;
    }

    @Override
    public void setLocation(URI location) {
        this.location = location;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public IndexStatus getIndexStatus() {
        return this.indexStatus;
    }

    @Override
    public void setIndexStatus(IndexStatus newValue) {
        this.indexStatus = newValue;
    }

    @Override
    public void putProperty(String key, String value) {
        this.putProperty(key, value, false);
    }

    @Override
    public Document toOSIS() {
        throw new UnsupportedOperationException("If you want to use this, implement it.");
    }

    public void setDriver(BookDriver driver) {
        this.driver = driver;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        BookMetaData that = (BookMetaData)obj;
        return this.getBookCategory().equals((Object)that.getBookCategory()) && this.getName().equals(that.getName()) && this.getInitials().equals(that.getInitials());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(BookMetaData obj) {
        int result = this.getBookCategory().compareTo(obj.getBookCategory());
        if (result == 0) {
            result = this.getAbbreviation().compareTo(obj.getAbbreviation());
        }
        if (result == 0) {
            result = this.getInitials().compareTo(obj.getInitials());
        }
        if (result == 0) {
            result = this.getName().compareTo(obj.getName());
        }
        return result;
    }

    public String toString() {
        String abbreviation;
        String internal = this.getInitials();
        if (internal.equals(abbreviation = this.getAbbreviation())) {
            return internal;
        }
        StringBuffer buf = new StringBuffer(internal);
        buf.append('(');
        buf.append(abbreviation);
        buf.append(')');
        return buf.toString();
    }
}

