/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseKey;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;

public class BitwisePassage
extends AbstractPassage {
    private static final long serialVersionUID = -5931560451407396276L;
    protected transient BitSet store;

    public BitwisePassage(Versification v11n) {
        super(v11n);
        this.store = new BitSet(v11n.maximumOrdinal() + 1);
    }

    protected BitwisePassage(Versification v11n, String refs, Key basis) throws NoSuchVerseException {
        super(v11n, refs);
        this.store = new BitSet(v11n.maximumOrdinal() + 1);
        this.addVerses(refs, basis);
    }

    protected BitwisePassage(Versification v11n, String refs) throws NoSuchVerseException {
        this(v11n, refs, null);
    }

    @Override
    public BitwisePassage clone() {
        BitwisePassage copy = (BitwisePassage)super.clone();
        copy.store = (BitSet)this.store.clone();
        return copy;
    }

    @Override
    public int countVerses() {
        return this.store.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    @Override
    public Iterator<Key> iterator() {
        return new VerseIterator();
    }

    @Override
    public boolean contains(Key obj) {
        for (Key aKey : obj) {
            Verse verse = (Verse)aKey;
            if (this.store.get(verse.getOrdinal())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(Key obj) {
        this.optimizeWrites();
        Verse firstVerse = null;
        Verse lastVerse = null;
        for (Key aKey : obj) {
            lastVerse = (Verse)aKey;
            if (firstVerse == null) {
                firstVerse = lastVerse;
            }
            this.store.set(lastVerse.getOrdinal());
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalAdded(this, firstVerse, lastVerse);
        }
    }

    public void addVersifiedOrdinal(int ordinal) {
        this.optimizeWrites();
        this.store.set(ordinal);
        if (this.suppressEvents == 0) {
            Verse verse = this.getVersification().decodeOrdinal(ordinal);
            this.fireIntervalAdded(this, verse, verse);
        }
    }

    @Override
    public void remove(Key obj) {
        this.optimizeWrites();
        Verse firstVerse = null;
        Verse lastVerse = null;
        for (Key aKey : obj) {
            lastVerse = (Verse)aKey;
            if (firstVerse == null) {
                firstVerse = lastVerse;
            }
            this.store.clear(lastVerse.getOrdinal());
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalAdded(this, firstVerse, lastVerse);
        }
    }

    @Override
    public void addAll(Key key) {
        if (key.isEmpty()) {
            return;
        }
        this.optimizeWrites();
        if (key instanceof BitwisePassage) {
            BitwisePassage thatRef = (BitwisePassage)key;
            this.store.or(thatRef.store);
        } else {
            super.addAll(key);
        }
        if (this.suppressEvents == 0 && !key.isEmpty()) {
            VerseKey<Passage> that;
            if (key instanceof Passage) {
                that = (Passage)key;
                this.fireIntervalAdded(this, that.getVerseAt(0), that.getVerseAt(that.countVerses() - 1));
            } else if (key instanceof VerseRange) {
                that = (VerseRange)key;
                this.fireIntervalAdded(this, ((VerseRange)that).getStart(), ((VerseRange)that).getEnd());
            } else if (key instanceof Verse) {
                that = (Verse)key;
                this.fireIntervalAdded(this, (Verse)that, (Verse)that);
            }
        }
    }

    @Override
    public void removeAll(Key key) {
        this.optimizeWrites();
        if (key instanceof BitwisePassage) {
            BitwisePassage thatRef = (BitwisePassage)key;
            this.store.andNot(thatRef.store);
        } else {
            super.removeAll(key);
        }
        if (this.suppressEvents == 0 && !key.isEmpty()) {
            VerseKey<Passage> that;
            if (key instanceof Passage) {
                that = (Passage)key;
                this.fireIntervalRemoved(this, that.getVerseAt(0), that.getVerseAt(that.countVerses() - 1));
            } else if (key instanceof VerseRange) {
                that = (VerseRange)key;
                this.fireIntervalRemoved(this, ((VerseRange)that).getStart(), ((VerseRange)that).getEnd());
            } else if (key instanceof Verse) {
                that = (Verse)key;
                this.fireIntervalRemoved(this, (Verse)that, (Verse)that);
            }
        }
    }

    @Override
    public void retainAll(Key key) {
        this.optimizeWrites();
        BitSet thatStore = null;
        if (key instanceof BitwisePassage) {
            thatStore = ((BitwisePassage)key).store;
        } else {
            Versification v11n = this.getVersification();
            thatStore = new BitSet(v11n.maximumOrdinal() + 1);
            for (Key aKey : key) {
                int ord = ((Verse)aKey).getOrdinal();
                if (!this.store.get(ord)) continue;
                thatStore.set(ord);
            }
        }
        this.store.and(thatStore);
        this.fireIntervalRemoved(this, null, null);
    }

    @Override
    public void clear() {
        this.optimizeWrites();
        this.store.clear();
        this.fireIntervalRemoved(this, null, null);
    }

    @Override
    public void blur(int verses, RestrictionType restrict) {
        assert (verses >= 0);
        this.optimizeWrites();
        this.raiseNormalizeProtection();
        if (!restrict.equals((Object)RestrictionType.NONE)) {
            super.blur(verses, restrict);
        } else {
            this.optimizeWrites();
            this.raiseEventSuppresion();
            this.raiseNormalizeProtection();
            int maximumOrdinal = this.getVersification().maximumOrdinal();
            BitSet newStore = new BitSet(maximumOrdinal + 1);
            int i = this.store.nextSetBit(0);
            while (i >= 0) {
                int start = Math.max(1, i - verses);
                int end = Math.min(maximumOrdinal, i + verses);
                for (int j = start; j <= end; ++j) {
                    newStore.set(j);
                }
                i = this.store.nextSetBit(i + 1);
            }
            this.store = newStore;
            this.lowerNormalizeProtection();
            if (this.lowerEventSuppressionAndTest()) {
                this.fireIntervalAdded(this, null, null);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.getVersification().getName());
        this.writeObjectSupport(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.optimizeWrites();
        in.defaultReadObject();
        String v11nName = in.readUTF();
        Versification v11n = Versifications.instance().getVersification(v11nName);
        this.store = new BitSet(v11n.maximumOrdinal() + 1);
        this.readObjectSupport(in);
    }

    private final class VerseIterator
    implements Iterator<Key> {
        private int next = -1;

        public VerseIterator() {
            this.calculateNext();
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0;
        }

        @Override
        public Key next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Verse retcode = BitwisePassage.this.getVersification().decodeOrdinal(this.next);
            this.calculateNext();
            return retcode;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            BitwisePassage.this.store.clear(this.next);
        }

        private void calculateNext() {
            this.next = BitwisePassage.this.store.nextSetBit(this.next + 1);
        }
    }
}

