/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.KeyType;
import org.crosswire.jsword.book.sword.Backend;
import org.crosswire.jsword.book.sword.BlockType;
import org.crosswire.jsword.book.sword.GenBookBackend;
import org.crosswire.jsword.book.sword.RawBackend;
import org.crosswire.jsword.book.sword.RawFileBackend;
import org.crosswire.jsword.book.sword.RawLDBackend;
import org.crosswire.jsword.book.sword.SwordBook;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordDailyDevotion;
import org.crosswire.jsword.book.sword.SwordDictionary;
import org.crosswire.jsword.book.sword.SwordGenBook;
import org.crosswire.jsword.book.sword.ZLDBackend;
import org.crosswire.jsword.book.sword.ZVerseBackend;

public enum BookType {
    RAW_TEXT("RawText", BookCategory.BIBLE, KeyType.VERSE){

        @Override
        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        @Override
        protected Backend getBackend(SwordBookMetaData sbmd) throws BookException {
            return new RawBackend(sbmd, 2);
        }
    }
    ,
    Z_TEXT("zText", BookCategory.BIBLE, KeyType.VERSE){

        @Override
        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        @Override
        protected Backend getBackend(SwordBookMetaData sbmd) throws BookException {
            BlockType blockType = BlockType.fromString(sbmd.getProperty("BlockType"));
            return new ZVerseBackend(sbmd, blockType);
        }
    }
    ,
    RAW_COM("RawCom", BookCategory.COMMENTARY, KeyType.VERSE){

        @Override
        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        @Override
        protected Backend getBackend(SwordBookMetaData sbmd) throws BookException {
            return new RawBackend(sbmd, 2);
        }
    }
    ,
    RAW_COM4("RawCom4", BookCategory.COMMENTARY, KeyType.VERSE){

        @Override
        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        @Override
        protected Backend getBackend(SwordBookMetaData sbmd) throws BookException {
            return new RawBackend(sbmd, 4);
        }
    }
    ,
    Z_COM("zCom", BookCategory.COMMENTARY, KeyType.VERSE){

        @Override
        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        @Override
        protected Backend getBackend(SwordBookMetaData sbmd) throws BookException {
            BlockType blockType = BlockType.fromString(sbmd.getProperty("BlockType"));
            return new ZVerseBackend(sbmd, blockType);
        }
    }
    ,
    HREF_COM("HREFCom", BookCategory.COMMENTARY, KeyType.VERSE){

        @Override
        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        @Override
        protected Backend getBackend(SwordBookMetaData sbmd) throws BookException {
            return new RawBackend(sbmd, 2);
        }
    }
    ,
    RAW_FILES("RawFiles", BookCategory.COMMENTARY, KeyType.VERSE){

        @Override
        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordBook(sbmd, backend);
        }

        @Override
        protected Backend getBackend(SwordBookMetaData sbmd) throws BookException {
            return new RawFileBackend(sbmd, 2);
        }
    }
    ,
    RAW_LD("RawLD", BookCategory.DICTIONARY, KeyType.LIST){

        @Override
        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            if (sbmd.getBookCategory().equals((Object)BookCategory.DAILY_DEVOTIONS)) {
                return new SwordDailyDevotion(sbmd, backend);
            }
            return new SwordDictionary(sbmd, backend);
        }

        @Override
        protected Backend getBackend(SwordBookMetaData sbmd) throws BookException {
            return new RawLDBackend(sbmd, 2);
        }
    }
    ,
    RAW_LD4("RawLD4", BookCategory.DICTIONARY, KeyType.LIST){

        @Override
        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            if (sbmd.getBookCategory().equals((Object)BookCategory.DAILY_DEVOTIONS)) {
                return new SwordDailyDevotion(sbmd, backend);
            }
            return new SwordDictionary(sbmd, backend);
        }

        @Override
        protected Backend getBackend(SwordBookMetaData sbmd) throws BookException {
            return new RawLDBackend(sbmd, 4);
        }
    }
    ,
    Z_LD("zLD", BookCategory.DICTIONARY, KeyType.LIST){

        @Override
        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            if (sbmd.getBookCategory().equals((Object)BookCategory.DAILY_DEVOTIONS)) {
                return new SwordDailyDevotion(sbmd, backend);
            }
            return new SwordDictionary(sbmd, backend);
        }

        @Override
        protected Backend getBackend(SwordBookMetaData sbmd) throws BookException {
            return new ZLDBackend(sbmd);
        }
    }
    ,
    RAW_GEN_BOOK("RawGenBook", BookCategory.GENERAL_BOOK, KeyType.TREE){

        @Override
        protected Book getBook(SwordBookMetaData sbmd, Backend backend) {
            return new SwordGenBook(sbmd, backend);
        }

        @Override
        protected Backend getBackend(SwordBookMetaData sbmd) throws BookException {
            return new GenBookBackend(sbmd);
        }
    };

    private String name;
    private BookCategory category;
    private KeyType keyType;

    private BookType(String name, BookCategory category, KeyType type) {
        this.name = name;
        this.category = category;
        this.keyType = type;
    }

    public static BookType getBookType(String name) {
        for (BookType v : BookType.values()) {
            if (!v.name().equalsIgnoreCase(name)) continue;
            return v;
        }
        throw new IllegalArgumentException(JSOtherMsg.lookupText("BookType {0} is not defined!", name));
    }

    public BookCategory getBookCategory() {
        return this.category;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public boolean isSupported(SwordBookMetaData sbmd) {
        return this.category != null && sbmd != null;
    }

    public Book createBook(SwordBookMetaData sbmd) throws BookException {
        return this.getBook(sbmd, this.getBackend(sbmd));
    }

    protected abstract Book getBook(SwordBookMetaData var1, Backend var2);

    protected abstract Backend getBackend(SwordBookMetaData var1) throws BookException;

    public static BookType fromString(String name) {
        for (BookType v : BookType.values()) {
            if (!v.name.equalsIgnoreCase(name)) continue;
            return v;
        }
        throw new ClassCastException(JSOtherMsg.lookupText("DataType {0} is not defined!", name));
    }

    public String toString() {
        return this.name;
    }
}

