/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.search;

import org.crosswire.jsword.index.query.QueryDecorator;
import org.crosswire.jsword.index.query.QueryDecoratorFactory;

public enum SearchType {
    PHRASE("Phrase"){

        @Override
        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decoratePhrase(queryWords);
        }
    }
    ,
    ALL_WORDS("All"){

        @Override
        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateAllWords(queryWords);
        }
    }
    ,
    ANY_WORDS("Any"){

        @Override
        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateAnyWords(queryWords);
        }
    }
    ,
    NOT_WORDS("Not"){

        @Override
        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateNotWords(queryWords);
        }
    }
    ,
    START_WORDS("Start"){

        @Override
        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateStartWords(queryWords);
        }
    }
    ,
    SPELL_WORDS("Spell"){

        @Override
        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateSpellWords(queryWords);
        }
    }
    ,
    RANGE("Range"){

        @Override
        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateRange(queryWords);
        }
    };

    private String name;
    protected static final QueryDecorator SEARCH_SYNTAX;

    private SearchType(String name) {
        this.name = name;
    }

    public abstract String decorate(String var1);

    public static SearchType fromString(String name) {
        for (SearchType v : SearchType.values()) {
            if (!v.name.equalsIgnoreCase(name)) continue;
            return v;
        }
        throw new ClassCastException("Not a valid search type");
    }

    public String toString() {
        return this.name;
    }

    static {
        SEARCH_SYNTAX = QueryDecoratorFactory.getSearchSyntax();
    }
}

