/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.crosswire.common.compress.CompressorType;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.BlockType;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.state.OpenFileStateManager;
import org.crosswire.jsword.book.sword.state.ZVerseBackendState;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.RocketPassage;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.versification.Testament;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZVerseBackend
extends AbstractBackend<ZVerseBackendState> {
    private final BlockType blockType;
    private static final int IDX_ENTRY_SIZE = 10;
    private static final int COMP_ENTRY_SIZE = 12;
    private static final Logger log = LoggerFactory.getLogger(ZVerseBackend.class);

    public ZVerseBackend(SwordBookMetaData sbmd, BlockType blockType) {
        super(sbmd);
        this.blockType = blockType;
    }

    @Override
    public boolean contains(Key key) {
        return this.getRawTextLength(key) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRawTextLength(Key key) {
        ZVerseBackendState rafBook = null;
        try {
            rafBook = this.initState();
            String v11nName = this.getBookMetaData().getProperty("Versification");
            Versification v11n = Versifications.instance().getVersification(v11nName);
            Verse verse = KeyUtil.getVerse(key);
            int index = verse.getOrdinal();
            Testament testament = v11n.getTestament(index);
            index = v11n.getTestamentOrdinal(index);
            RandomAccessFile idxRaf = rafBook.getIdxRaf(testament);
            if (idxRaf == null) {
                int n = 0;
                return n;
            }
            byte[] temp = SwordUtil.readRAF(idxRaf, 1L * (long)index * 10L, 10);
            if (temp == null || temp.length == 0) {
                int n = 0;
                return n;
            }
            int n = SwordUtil.decodeLittleEndian16(temp, 8);
            return n;
        }
        catch (IOException e) {
            int n = 0;
            return n;
        }
        catch (BookException e) {
            log.error("Unable to ascertain key validity", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            OpenFileStateManager.instance().release(rafBook);
        }
    }

    @Override
    public Key getGlobalKeyList() throws BookException {
        ZVerseBackendState rafBook = null;
        try {
            rafBook = this.initState();
            String v11nName = this.getBookMetaData().getProperty("Versification");
            Versification v11n = Versifications.instance().getVersification(v11nName);
            Testament[] testaments = new Testament[]{Testament.OLD, Testament.NEW};
            RocketPassage passage = new RocketPassage(v11n);
            passage.raiseEventSuppresion();
            passage.raiseNormalizeProtection();
            for (Testament currentTestament : testaments) {
                RandomAccessFile idxRaf = rafBook.getIdxRaf(currentTestament);
                if (idxRaf == null) continue;
                int maxIndex = v11n.getCount(currentTestament) - 1;
                byte[] temp = SwordUtil.readRAF(idxRaf, 0L, 10 * maxIndex);
                for (int ii = 0; ii < temp.length; ii += 10) {
                    if (temp[ii + 8] == 0 && temp[ii + 9] == 0) continue;
                    int ordinal = ii / 10;
                    passage.addVersifiedOrdinal(v11n.getOrdinal(currentTestament, ordinal));
                }
            }
            passage.lowerNormalizeProtection();
            passage.lowerEventSuppressionAndTest();
            RocketPassage rocketPassage = passage;
            return rocketPassage;
        }
        catch (IOException e) {
            throw new BookException(JSMsg.gettext("Unable to read key list from book.", new Object[0]));
        }
        finally {
            OpenFileStateManager.instance().release(rafBook);
        }
    }

    @Override
    public ZVerseBackendState initState() throws BookException {
        return OpenFileStateManager.instance().getZVerseBackendState(this.getBookMetaData(), this.blockType);
    }

    @Override
    public String readRawContent(ZVerseBackendState rafBook, Key key) throws IOException {
        SwordBookMetaData bookMetaData = this.getBookMetaData();
        String charset = bookMetaData.getBookCharset();
        String compressType = bookMetaData.getProperty("CompressType");
        String v11nName = this.getBookMetaData().getProperty("Versification");
        Versification v11n = Versifications.instance().getVersification(v11nName);
        Verse verse = KeyUtil.getVerse(key);
        int index = verse.getOrdinal();
        Testament testament = v11n.getTestament(index);
        index = v11n.getTestamentOrdinal(index);
        RandomAccessFile idxRaf = rafBook.getIdxRaf(testament);
        RandomAccessFile compRaf = rafBook.getCompRaf(testament);
        RandomAccessFile textRaf = rafBook.getTextRaf(testament);
        if (idxRaf == null) {
            return "";
        }
        byte[] temp = SwordUtil.readRAF(idxRaf, 1L * (long)index * 10L, 10);
        if (temp == null || temp.length == 0) {
            return "";
        }
        long blockNum = SwordUtil.decodeLittleEndian32(temp, 0);
        int verseStart = SwordUtil.decodeLittleEndian32(temp, 4);
        int verseSize = SwordUtil.decodeLittleEndian16(temp, 8);
        byte[] uncompressed = null;
        if (blockNum == rafBook.getLastBlockNum() && testament == rafBook.getLastTestament()) {
            uncompressed = rafBook.getLastUncompressed();
        } else {
            temp = SwordUtil.readRAF(compRaf, blockNum * 12L, 12);
            if (temp == null || temp.length == 0) {
                return "";
            }
            int blockStart = SwordUtil.decodeLittleEndian32(temp, 0);
            int blockSize = SwordUtil.decodeLittleEndian32(temp, 4);
            int uncompressedSize = SwordUtil.decodeLittleEndian32(temp, 8);
            byte[] data = SwordUtil.readRAF(textRaf, blockStart, blockSize);
            this.decipher(data);
            uncompressed = CompressorType.fromString(compressType).getCompressor(data).uncompress(uncompressedSize).toByteArray();
            rafBook.setLastBlockNum(blockNum);
            rafBook.setLastTestament(testament);
            rafBook.setLastUncompressed(uncompressed);
        }
        byte[] chopped = new byte[verseSize];
        System.arraycopy(uncompressed, verseStart, chopped, 0, verseSize);
        return SwordUtil.decode(key.getName(), chopped, charset);
    }

    @Override
    public void setAliasKey(ZVerseBackendState rafBook, Key alias, Key source) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawText(ZVerseBackendState rafBook, Key key, String text) throws BookException, IOException {
        throw new UnsupportedOperationException();
    }

    public void dumpIdxRaf(Versification v11n, int ordinalStart, RandomAccessFile raf) {
        long end = -1L;
        try {
            end = raf.length();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int i = ordinalStart;
        StringBuilder buf = new StringBuilder();
        System.out.println("osisID\tblock\tstart\tsize");
        for (long offset = 0L; offset < end; offset += 10L) {
            byte[] temp = null;
            try {
                temp = SwordUtil.readRAF(raf, offset, 10);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            long blockNum = -1L;
            int verseStart = -1;
            int verseSize = -1;
            if (temp != null && temp.length > 0) {
                blockNum = SwordUtil.decodeLittleEndian32(temp, 0);
                verseStart = SwordUtil.decodeLittleEndian32(temp, 4);
                verseSize = SwordUtil.decodeLittleEndian16(temp, 8);
            }
            buf.setLength(0);
            buf.append(v11n.decodeOrdinal(i++).getOsisID());
            buf.append('\t');
            buf.append(blockNum);
            buf.append('\t');
            buf.append(verseStart);
            buf.append('\t');
            buf.append(verseSize);
            System.out.println(buf.toString());
        }
    }

    public void dumpCompRaf(RandomAccessFile raf) {
        long end = -1L;
        try {
            end = raf.length();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int blockNum = 0;
        StringBuilder buf = new StringBuilder();
        System.out.println("block\tstart\tsize\tuncompressed");
        for (long offset = 0L; offset < end; offset += 12L) {
            byte[] temp = null;
            try {
                temp = SwordUtil.readRAF(raf, offset, 12);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int blockStart = -1;
            int blockSize = -1;
            int uncompressedSize = -1;
            if (temp != null && temp.length > 0) {
                blockStart = SwordUtil.decodeLittleEndian32(temp, 0);
                blockSize = SwordUtil.decodeLittleEndian32(temp, 4);
                uncompressedSize = SwordUtil.decodeLittleEndian32(temp, 8);
            }
            buf.setLength(0);
            buf.append(blockNum);
            buf.append('\t');
            buf.append(blockStart);
            buf.append('\t');
            buf.append(blockSize);
            buf.append('\t');
            buf.append(uncompressedSize);
            System.out.println(buf.toString());
        }
    }
}

