/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.File;
import java.net.URI;
import org.crosswire.common.util.NetUtil;

public enum OSType {
    MAC("Mac"){

        @Override
        public URI getUserArea() {
            return NetUtil.lengthenURI(1.getUserHome(), OSType.MAC_USER_DATA_AREA);
        }

        @Override
        public URI getUserAreaFolder(String hiddenFolderName, String visibleFolderName) {
            return NetUtil.lengthenURI(this.getUserArea(), visibleFolderName);
        }
    }
    ,
    WIN32("Win"){

        @Override
        public URI getUserArea() {
            return NetUtil.lengthenURI(2.getUserHome(), OSType.WIN32_USER_DATA_AREA);
        }

        @Override
        public URI getUserAreaFolder(String hiddenFolderName, String visibleFolderName) {
            return NetUtil.lengthenURI(this.getUserArea(), visibleFolderName);
        }
    }
    ,
    DEFAULT("*nix"){

        @Override
        public URI getUserArea() {
            return 3.getUserHome();
        }

        @Override
        public URI getUserAreaFolder(String hiddenFolderName, String visibleFolderName) {
            return NetUtil.lengthenURI(this.getUserArea(), hiddenFolderName);
        }
    };

    private String name;
    private static final String WIN32_USER_DATA_AREA = "Application Data";
    private static final String MAC_USER_DATA_AREA = "Library/Application Support";
    private static OSType osType;

    private OSType(String name) {
        this.name = name;
    }

    public abstract URI getUserArea();

    public abstract URI getUserAreaFolder(String var1, String var2);

    public static URI getUserHome() {
        return NetUtil.getURI(new File(System.getProperty("user.home")));
    }

    public static OSType getOSType() {
        return osType;
    }

    public static OSType fromString(String name) {
        for (OSType v : OSType.values()) {
            if (!name.startsWith(v.name)) continue;
            return v;
        }
        return DEFAULT;
    }

    public String toString() {
        return this.name;
    }

    static {
        osType = OSType.fromString(System.getProperty("os.name"));
    }
}

