/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.util;

import java.io.IOException;
import java.net.URI;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.jsword.JSMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebWarning {
    private static WebWarning instance = new WebWarning();
    private static final String SHOWN_KEY = "shown";
    private static final boolean DEFAULT_SHOWN = true;
    private boolean shown;
    private static final Logger log = LoggerFactory.getLogger(WebWarning.class);

    private WebWarning() {
        try {
            PropertyMap props = ResourceUtil.getProperties(this.getClass().getName());
            this.shown = Boolean.valueOf(props.get(SHOWN_KEY, Boolean.valueOf(true).toString()));
        }
        catch (IOException e) {
            this.shown = true;
        }
    }

    public static WebWarning instance() {
        return instance;
    }

    public void setShown(boolean newShown) {
        try {
            this.shown = newShown;
            PropertyMap props = new PropertyMap();
            props.put(SHOWN_KEY, Boolean.valueOf(this.shown).toString());
            URI outputURI = CWProject.instance().getWritableURI(this.getClass().getName(), ".properties");
            NetUtil.storeProperties(props, outputURI, "JSword WebWarning");
        }
        catch (IOException ex) {
            log.error("Failed to save JSword WebWarning", (Throwable)ex);
        }
    }

    public boolean isShown() {
        return this.shown;
    }

    public static void setWarningShown(boolean newShown) {
        WebWarning.instance().setShown(newShown);
    }

    public static boolean isWarningShown() {
        return WebWarning.instance().isShown();
    }

    public String getWarning() {
        return JSMsg.gettext("You are about to access the Internet. Are you sure you want to do this?", new Object[0]);
    }

    public String getShownWarningLabel() {
        return JSMsg.gettext("Show this warning every time the Internet is accessed.", new Object[0]);
    }
}

