/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.util;

import java.io.IOException;
import java.net.URI;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.index.IndexStatus;

public final class IndexDownloader {
    private static final String TEMP_PREFIX = "jsword-index";
    private static final String TEMP_SUFFIX = "dat";

    private IndexDownloader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadIndex(Book book, Installer installer) throws IOException, InstallException, BookException {
        URI tempDownload = NetUtil.getTemporaryURI(TEMP_PREFIX, TEMP_SUFFIX);
        IndexStatus finalStatus = IndexStatus.UNDONE;
        try {
            installer.downloadSearchIndex(book, tempDownload);
            IndexManager idxman = IndexManagerFactory.getIndexManager();
            book.setIndexStatus(IndexStatus.CREATING);
            idxman.installDownloadedIndex(book, tempDownload);
            finalStatus = IndexStatus.DONE;
        }
        finally {
            book.setIndexStatus(finalStatus);
            if (tempDownload != null) {
                NetUtil.delete(tempDownload);
            }
        }
    }
}

