/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.crosswire.common.util.FileUtil;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.basic.AbstractBookDriver;
import org.crosswire.jsword.book.sword.BookType;
import org.crosswire.jsword.book.sword.ConfigEntry;
import org.crosswire.jsword.book.sword.MissingDataFilesException;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordBookPath;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.index.IndexStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwordBookDriver
extends AbstractBookDriver {
    private static final BookDriver INSTANCE = new SwordBookDriver();
    private static final Logger log = LoggerFactory.getLogger(SwordBookDriver.class);

    @Override
    public String getDriverName() {
        return "Sword";
    }

    @Override
    public Book[] getBooks() {
        ConfigEntry.resetStatistics();
        ArrayList<Book> valid = new ArrayList<Book>();
        File[] dirs = SwordBookPath.getSwordPath();
        for (int j = 0; j < dirs.length; ++j) {
            this.getBooks(valid, dirs[j]);
        }
        ConfigEntry.dumpStatistics();
        return valid.toArray(new Book[valid.size()]);
    }

    private void getBooks(List<Book> valid, File bookDir) {
        File mods = new File(bookDir, "mods.d");
        if (mods.isDirectory()) {
            String[] bookConfs = SwordBookPath.getBookList(mods);
            for (int i = 0; i < bookConfs.length; ++i) {
                String bookConf = bookConfs[i];
                try {
                    SwordBookMetaData sbmd;
                    File configfile = new File(mods, bookConf);
                    String internal = bookConf;
                    if (internal.endsWith(".conf")) {
                        internal = internal.substring(0, internal.length() - 5);
                    }
                    if (!(sbmd = new SwordBookMetaData(configfile, internal, NetUtil.getURI(bookDir))).isSupported()) continue;
                    sbmd.setDriver(this);
                    Book book = this.createBook(sbmd);
                    if (valid.contains(book)) continue;
                    valid.add(book);
                    IndexManager imanager = IndexManagerFactory.getIndexManager();
                    if (imanager.isIndexed(book)) {
                        sbmd.setIndexStatus(IndexStatus.DONE);
                        continue;
                    }
                    sbmd.setIndexStatus(IndexStatus.UNDONE);
                    continue;
                }
                catch (IOException e) {
                    log.warn("Couldn't create SwordBookMetaData", (Throwable)e);
                    continue;
                }
                catch (MissingDataFilesException e) {
                    log.warn(e.getMessage());
                    log.trace(e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (BookException e) {
                    log.warn("Couldn't create SwordBookMetaData", (Throwable)e);
                }
            }
        } else {
            log.debug("mods.d directory at {} does not exist", (Object)mods);
        }
    }

    @Override
    public boolean isDeletable(Book dead) {
        SwordBookMetaData sbmd = (SwordBookMetaData)dead.getBookMetaData();
        File confFile = sbmd.getConfigFile();
        return confFile != null && confFile.exists();
    }

    @Override
    public void delete(Book dead) throws BookException {
        URI loc;
        SwordBookMetaData sbmd = (SwordBookMetaData)dead.getBookMetaData();
        File confFile = sbmd.getConfigFile();
        if (confFile == null || !confFile.exists()) {
            throw new BookException(JSMsg.gettext("Unable to delete: {0}", confFile));
        }
        List<File> failures = FileUtil.delete(confFile);
        if (failures.isEmpty() && (loc = sbmd.getLocation()) != null) {
            File bookDir = new File(loc.getPath());
            failures = FileUtil.delete(bookDir);
            Books.installed().removeBook(dead);
        }
        if (!failures.isEmpty()) {
            throw new BookException(JSMsg.gettext("Unable to delete: {0}", failures.get(0)));
        }
    }

    public static BookDriver instance() {
        return INSTANCE;
    }

    public static void registerNewBook(SwordBookMetaData sbmd) throws BookException {
        BookDriver[] drivers = Books.installed().getDriversByClass(SwordBookDriver.class);
        for (int i = 0; i < drivers.length; ++i) {
            SwordBookDriver sdriver = (SwordBookDriver)drivers[i];
            Book book = sdriver.createBook(sbmd);
            Books.installed().addBook(book);
        }
    }

    private Book createBook(SwordBookMetaData sbmd) throws BookException {
        BookType modtype = sbmd.getBookType();
        if (modtype == null || modtype.getBookCategory() == null) {
            throw new BookException(JSOtherMsg.lookupText("Unsupported type: {0} when reading {1}", new Object[0]));
        }
        return modtype.createBook(sbmd);
    }
}

