/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.crosswire.common.icu.NumberShaper;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.jsword.internationalisation.LocaleProviderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgBase {
    private static Map<Locale, Map<String, ResourceBundle>> localeToResourceMap = new HashMap<Locale, Map<String, ResourceBundle>>();
    private NumberShaper shaper = new NumberShaper();
    private static final Logger log = LoggerFactory.getLogger(MsgBase.class);

    protected MsgBase() {
    }

    public String lookup(String key, Object ... params) {
        String rawMessage = this.obtainString(key);
        if (params.length == 0) {
            return this.shaper.shape(rawMessage);
        }
        rawMessage = rawMessage.replaceAll("'", "''");
        return this.shaper.shape(MessageFormat.format(rawMessage, params));
    }

    private String obtainString(String key) {
        try {
            if (this.getLocalisedResources() != null) {
                return this.getLocalisedResources().getString(key);
            }
        }
        catch (MissingResourceException ex) {
            log.error("Missing resource: Locale={} name={} package={}", new Object[]{LocaleProviderManager.getLocale(), key, this.getClass().getName()});
        }
        return key;
    }

    private ResourceBundle getLocalisedResources() {
        Class<?> implementingClass = this.getClass();
        String className = implementingClass.getName();
        String shortClassName = ClassUtil.getShortClassName(className);
        Locale currentUserLocale = LocaleProviderManager.getLocale();
        Map<String, ResourceBundle> localisedResourceMap = this.getLazyLocalisedResourceMap(currentUserLocale);
        ResourceBundle resourceBundle = localisedResourceMap.get(className);
        if (resourceBundle == null) {
            resourceBundle = this.getResourceBundleForClass(implementingClass, className, shortClassName, currentUserLocale, localisedResourceMap);
        }
        if (resourceBundle == null) {
            resourceBundle = this.getResourceBundleForClass(implementingClass, className, shortClassName, Locale.ENGLISH, localisedResourceMap);
        }
        if (resourceBundle == null) {
            log.error("Missing resources: Locale={} class={}", (Object)currentUserLocale, (Object)className);
            throw new MissingResourceException("Unable to find the language resources.", className, shortClassName);
        }
        return resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getResourceBundleForClass(Class<? extends MsgBase> implementingClass, String className, String shortClassName, Locale currentUserLocale, Map<String, ResourceBundle> localisedResourceMap) {
        Class<MsgBase> clazz = MsgBase.class;
        synchronized (MsgBase.class) {
            ResourceBundle resourceBundle = localisedResourceMap.get(className);
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(shortClassName, currentUserLocale, CWClassLoader.instance(implementingClass));
                    localisedResourceMap.put(className, resourceBundle);
                }
                catch (MissingResourceException ex) {
                    log.warn("Assuming key is the default message {}", (Object)className);
                }
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return resourceBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, ResourceBundle> getLazyLocalisedResourceMap(Locale currentUserLocale) {
        Map<String, ResourceBundle> localisedResourceMap = localeToResourceMap.get(currentUserLocale);
        if (localisedResourceMap != null) return localisedResourceMap;
        Class<MsgBase> clazz = MsgBase.class;
        synchronized (MsgBase.class) {
            localisedResourceMap = localeToResourceMap.get(currentUserLocale);
            if (localisedResourceMap != null) return localisedResourceMap;
            localisedResourceMap = new HashMap<String, ResourceBundle>(512);
            localeToResourceMap.put(currentUserLocale, localisedResourceMap);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return localisedResourceMap;
        }
    }
}

