/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification.system;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.SystemCatholic;
import org.crosswire.jsword.versification.system.SystemCatholic2;
import org.crosswire.jsword.versification.system.SystemGerman;
import org.crosswire.jsword.versification.system.SystemKJV;
import org.crosswire.jsword.versification.system.SystemKJVA;
import org.crosswire.jsword.versification.system.SystemLeningrad;
import org.crosswire.jsword.versification.system.SystemLuther;
import org.crosswire.jsword.versification.system.SystemMT;
import org.crosswire.jsword.versification.system.SystemNRSV;
import org.crosswire.jsword.versification.system.SystemNRSVA;
import org.crosswire.jsword.versification.system.SystemSynodal;
import org.crosswire.jsword.versification.system.SystemSynodalP;
import org.crosswire.jsword.versification.system.SystemVulg;

public final class Versifications {
    public static final String DEFAULT_V11N = "KJV";
    private Set<String> known = new HashSet<String>();
    private Map<String, Versification> fluffed;
    private static final Versifications instance = new Versifications();

    public static Versifications instance() {
        return instance;
    }

    @Deprecated
    public synchronized Versification getDefaultVersification() {
        return this.getVersification(DEFAULT_V11N);
    }

    public synchronized Versification getVersification(String name) {
        Versification rs;
        String actual = name;
        if (actual == null) {
            actual = DEFAULT_V11N;
        }
        if ((rs = this.fluffed.get(actual)) == null && (rs = this.fluff(actual)) != null) {
            this.fluffed.put(actual, rs);
        }
        return rs;
    }

    public synchronized boolean isDefined(String name) {
        return name == null || this.known.contains(name);
    }

    private Versification fluff(String name) {
        if (DEFAULT_V11N.equals(name)) {
            return new SystemKJV();
        }
        if ("Catholic".equals(name)) {
            return new SystemCatholic();
        }
        if ("Catholic2".equals(name)) {
            return new SystemCatholic2();
        }
        if ("German".equals(name)) {
            return new SystemGerman();
        }
        if ("KJVA".equals(name)) {
            return new SystemKJVA();
        }
        if ("Leningrad".equals(name)) {
            return new SystemLeningrad();
        }
        if ("Luther".equals(name)) {
            return new SystemLuther();
        }
        if ("MT".equals(name)) {
            return new SystemMT();
        }
        if ("NRSV".equals(name)) {
            return new SystemNRSV();
        }
        if ("NRSVA".equals(name)) {
            return new SystemNRSVA();
        }
        if ("Synodal".equals(name)) {
            return new SystemSynodal();
        }
        if ("SynodalP".equals(name)) {
            return new SystemSynodalP();
        }
        if ("Vulg".equals(name)) {
            return new SystemVulg();
        }
        return null;
    }

    public synchronized void register(Versification rs) {
        this.fluffed.put(rs.getName(), rs);
        this.known.add(rs.getName());
    }

    private Versifications() {
        this.known.add("Catholic");
        this.known.add("Catholic2");
        this.known.add("German");
        this.known.add(DEFAULT_V11N);
        this.known.add("KJVA");
        this.known.add("Leningrad");
        this.known.add("Luther");
        this.known.add("MT");
        this.known.add("NRSV");
        this.known.add("NRSVA");
        this.known.add("Synodal");
        this.known.add("SynodalP");
        this.known.add("Vulg");
        this.fluffed = new HashMap<String, Versification>();
    }
}

