/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.LowerCaseTokenizer;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.util.Version;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.SavedStreams;

public class EnglishLuceneAnalyzer
extends AbstractBookAnalyzer {
    private final Version matchVersion = Version.LUCENE_29;

    public EnglishLuceneAnalyzer() {
        this.stopSet = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        LowerCaseTokenizer result = new LowerCaseTokenizer(reader);
        if (this.doStopWords && this.stopSet != null) {
            result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stopSet);
        }
        if (this.doStemming) {
            result = new PorterStemFilter((TokenStream)result);
        }
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams((Tokenizer)new LowerCaseTokenizer(reader));
            if (this.doStopWords && this.stopSet != null) {
                streams.setResult((TokenStream)new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.getResult(), this.stopSet));
            }
            if (this.doStemming) {
                streams.setResult((TokenStream)new PorterStemFilter(streams.getResult()));
            }
            this.setPreviousTokenStream(streams);
        } else {
            streams.getSource().reset(reader);
        }
        return streams.getResult();
    }
}

