/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.util.regex.Pattern;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.Version;
import org.crosswire.jsword.book.BookCategory;

public enum ConfigEntryType {
    INITIALS("Initials"){

        @Override
        public boolean isSynthetic() {
            return true;
        }
    }
    ,
    DATA_PATH("DataPath"){

        @Override
        public boolean isAllowed(String value) {
            return true;
        }
    }
    ,
    DESCRIPTION("Description"),
    MOD_DRV("ModDrv", -1, "RawText", "zText", "RawCom", "RawCom4", "zCom", "HREFCom", "RawFiles", "RawLD", "RawLD4", "zLD", "RawGenBook"),
    COMPRESS_TYPE("CompressType", 0, "LZSS", "ZIP"),
    BLOCK_TYPE("BlockType", 1, "BOOK", "CHAPTER", "VERSE"),
    BLOCK_COUNT("BlockCount", "200"){

        @Override
        public boolean isAllowed(String aValue) {
            try {
                Integer.parseInt(aValue);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public Object convert(String input) {
            try {
                return Integer.valueOf(input);
            }
            catch (NumberFormatException e) {
                return this.getDefault();
            }
        }
    }
    ,
    KEY_TYPE("KeyType", 0, "TreeKey", "VerseKey"),
    CIPHER_KEY("CipherKey"),
    VERSIFICATION("Versification", 3, "Catholic", "Catholic2", "German", "KJV", "KJVA", "Leningrad", "Luther", "MT", "NRSV", "NRSVA", "Synodal", "SynodalP", "Vulg"),
    GLOBAL_OPTION_FILTER("GlobalOptionFilter", -1, new String[]{"GBFStrongs", "GBFFootnotes", "GBFMorph", "GBFHeadings", "GBFRedLetterWords", "GBFScripref", "ThMLStrongs", "ThMLFootnotes", "ThMLScripref", "ThMLMorph", "ThMLHeadings", "ThMLVariants", "ThMLLemma", "UTF8Cantillation", "UTF8GreekAccents", "UTF8HebrewPoints", "OSISStrongs", "OSISFootnotes", "OSISScripref", "OSISMorph", "OSISHeadings", "OSISVariants", "OSISRedLetterWords", "OSISLemma", "OSISRuby", "OSISXlit", "OSISEnum"}){

        @Override
        public boolean mayRepeat() {
            return true;
        }
    }
    ,
    DIRECTION("Direction", 0, "LtoR", "RtoL", "bidi"),
    SOURCE_TYPE("SourceType", 0, "Plaintext", "GBF", "ThML", "OSIS", "TEI"),
    ENCODING("Encoding", 0, "Latin-1", "UTF-8"),
    DISPLAY_LEVEL("DisplayLevel", "1"){

        @Override
        public boolean isAllowed(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public Object convert(String input) {
            try {
                return Integer.valueOf(input);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
    ,
    FONT("Font"),
    OSIS_Q_TO_TICK("OSISqToTick", 0, new String[]{"true", "false"}){

        @Override
        public Object convert(String input) {
            return Boolean.valueOf(input);
        }
    }
    ,
    FEATURE("Feature", -1, new String[]{"StrongsNumbers", "GreekDef", "HebrewDef", "GreekParse", "HebrewParse", "DailyDevotion", "Glossary", "Images"}){

        @Override
        public boolean mayRepeat() {
            return true;
        }
    }
    ,
    GLOSSARY_FROM("GlossaryFrom"){

        @Override
        public Object convert(String input) {
            return new Language(input);
        }

        @Override
        public String unconvert(Object internal) {
            if (internal instanceof Language) {
                return ((Language)internal).getGivenSpecification();
            }
            return super.unconvert(internal);
        }
    }
    ,
    GLOSSARY_TO("GlossaryTo"){

        @Override
        public Object convert(String input) {
            return new Language(input);
        }

        @Override
        public String unconvert(Object internal) {
            if (internal instanceof Language) {
                return ((Language)internal).getGivenSpecification();
            }
            return super.unconvert(internal);
        }
    }
    ,
    ABBREVIATION("Abbreviation"),
    ABOUT("About"){

        @Override
        public boolean allowsContinuation() {
            return true;
        }

        @Override
        public boolean allowsRTF() {
            return true;
        }
    }
    ,
    VERSION("Version", "1.0"){

        @Override
        public boolean isAllowed(String aValue) {
            try {
                new Version(aValue);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        @Override
        public Object convert(String input) {
            try {
                return new Version(input);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
    ,
    HISTORY("History"){

        @Override
        public boolean mayRepeat() {
            return true;
        }

        @Override
        public boolean reportDetails() {
            return false;
        }
    }
    ,
    MINIMUM_VERSION("MinimumVersion", "1.5.1a"),
    CATEGORY("Category", 0, new String[]{"Other", "Daily Devotional", "Glossaries", "Cults / Unorthodox / Questionable Material", "Essays", "Maps", "Images", "Biblical Texts", "Commentaries", "Lexicons / Dictionaries", "Generic Books"}){

        @Override
        public Object convert(String input) {
            return BookCategory.fromString(input);
        }
    }
    ,
    LCSH("LCSH"),
    LANG("Lang", "en"){

        @Override
        public Object convert(String input) {
            return new Language(input);
        }

        @Override
        public String unconvert(Object internal) {
            if (internal instanceof Language) {
                return ((Language)internal).getGivenSpecification();
            }
            return super.unconvert(internal);
        }
    }
    ,
    INSTALL_SIZE("InstallSize"){

        @Override
        public boolean isAllowed(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public Object convert(String input) {
            try {
                return Integer.valueOf(input);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
    ,
    SWORD_VERSION_DATE("SwordVersionDate"){
        private Pattern validDatePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");

        @Override
        public boolean isAllowed(String value) {
            return this.validDatePattern.matcher(value).matches();
        }
    }
    ,
    OBSOLETES("Obsoletes"){

        @Override
        public boolean mayRepeat() {
            return true;
        }

        @Override
        public boolean reportDetails() {
            return false;
        }
    }
    ,
    OSIS_VERSION("OSISVersion"),
    COPYRIGHT("Copyright"){

        @Override
        public boolean allowsContinuation() {
            return true;
        }
    }
    ,
    COPYRIGHT_HOLDER("CopyrightHolder"),
    COPYRIGHT_DATE("CopyrightDate"){
        private Pattern validDatePattern = Pattern.compile("\\d{4}(\\s*-\\s*\\d{4})?(\\s*,\\s*\\d{4}(\\s*-\\s*\\d{4})?)*");

        @Override
        public boolean isAllowed(String value) {
            return this.validDatePattern.matcher(value).matches();
        }
    }
    ,
    COPYRIGHT_NOTES("CopyrightNotes"){

        @Override
        public boolean allowsContinuation() {
            return true;
        }

        @Override
        public boolean allowsRTF() {
            return true;
        }
    }
    ,
    COPYRIGHT_CONTACT_NAME("CopyrightContactName"){

        @Override
        public boolean allowsContinuation() {
            return true;
        }

        @Override
        public boolean allowsRTF() {
            return true;
        }
    }
    ,
    COPYRIGHT_CONTACT_NOTES("CopyrightContactNotes"){

        @Override
        public boolean allowsContinuation() {
            return true;
        }

        @Override
        public boolean allowsRTF() {
            return true;
        }
    }
    ,
    COPYRIGHT_CONTACT_ADDRESS("CopyrightContactAddress"){

        @Override
        public boolean allowsContinuation() {
            return true;
        }

        @Override
        public boolean allowsRTF() {
            return true;
        }
    }
    ,
    COPYRIGHT_CONTACT_EMAIL("CopyrightContactEmail"),
    SHORT_PROMO("ShortPromo"),
    SHORT_COPYRIGHT("ShortCopyright"),
    DISTRIBUTION_LICENSE("DistributionLicense", 0, "Public Domain", "Copyrighted", "Copyrighted; Free non-commercial distribution", "Copyrighted; Permission to distribute granted to CrossWire", "Copyrighted; Freely distributable", "Copyrighted; Permission granted to distribute non-commercially in SWORD format", "GFDL", "GPL", "Creative Commons: by-nc-nd", "Creative Commons: by-nc-sa", "Creative Commons: by-nc", "Creative Commons: by-nd", "Creative Commons: by-sa", "Creative Commons: by", "Creative Commons: CC0"),
    DISTRIBUTION_NOTES("DistributionNotes"){

        @Override
        public boolean allowsContinuation() {
            return true;
        }
    }
    ,
    TEXT_SOURCE("TextSource"){

        @Override
        public boolean allowsContinuation() {
            return true;
        }
    }
    ,
    UNLOCK_URL("UnlockURL"),
    DISTRIBUTION_SOURCE("DistributionSource"){

        @Override
        public boolean allowsContinuation() {
            return true;
        }
    }
    ,
    LOCAL_STRIP_FILTER("LocalStripFilter"),
    SEARCH_OPTION("SearchOption"),
    LIBRARY_URL("LibraryURL"){

        @Override
        public boolean isSynthetic() {
            return true;
        }
    }
    ,
    LOCATION_URL("LocationURL"){

        @Override
        public boolean isSynthetic() {
            return true;
        }
    };

    private final String name;
    private final Object defaultValue;
    private final String[] picks;
    public static final String DIRECTION_LTOR = "LtoR";
    public static final String DIRECTION_RTOL = "RtoL";
    public static final String DIRECTION_BIDI = "bidi";

    private ConfigEntryType(String name) {
        this.name = name;
        this.defaultValue = null;
        this.picks = null;
    }

    private ConfigEntryType(String name, String defaultValue) {
        this.name = name;
        this.defaultValue = this.convert(defaultValue);
        this.picks = null;
    }

    private ConfigEntryType(String name, int defaultPick, String ... picks) {
        this.name = name;
        this.defaultValue = defaultPick >= 0 && defaultPick < picks.length ? this.convert(picks[defaultPick]) : null;
        this.picks = picks;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAllowed(String value) {
        if (this.hasChoices()) {
            for (String pick : this.picks) {
                if (!pick.equalsIgnoreCase(value)) continue;
                return true;
            }
            return false;
        }
        return value != null;
    }

    public String filter(String value) {
        if (this.hasChoices()) {
            for (String pick : this.picks) {
                if (!pick.equals(value)) continue;
                return value;
            }
            for (String pick : this.picks) {
                if (!pick.equalsIgnoreCase(value)) continue;
                return pick;
            }
        }
        return value;
    }

    public boolean allowsRTF() {
        return false;
    }

    public boolean allowsContinuation() {
        return false;
    }

    public boolean mayRepeat() {
        return false;
    }

    public boolean reportDetails() {
        return true;
    }

    protected boolean hasChoices() {
        return this.picks != null;
    }

    public boolean isSynthetic() {
        return false;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public Object convert(String input) {
        return input;
    }

    public String unconvert(Object internal) {
        if (internal == null) {
            return null;
        }
        return internal.toString();
    }

    public static ConfigEntryType fromString(String name) {
        if (name != null) {
            if (name.startsWith(HISTORY.toString())) {
                return HISTORY;
            }
            for (ConfigEntryType o : ConfigEntryType.values()) {
                if (!name.equals(o.name)) continue;
                return o;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

