/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.EventListenerList;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.PluginUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.install.InstallerEvent;
import org.crosswire.jsword.book.install.InstallerFactory;
import org.crosswire.jsword.book.install.InstallerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstallManager {
    private static final String PREFIX = "Installer.";
    private Map<String, Class<InstallerFactory>> factories;
    private Map<String, Installer> installers = new LinkedHashMap<String, Installer>();
    private static EventListenerList listeners = new EventListenerList();
    private static final Logger log = LoggerFactory.getLogger(InstallManager.class);

    public InstallManager() {
        try {
            PropertyMap sitemap = PluginUtil.getPlugin(this.getClass());
            this.factories = PluginUtil.getImplementorsMap(InstallerFactory.class);
            int i = 0;
            String def = sitemap.get(PREFIX + ++i);
            while (def != null) {
                try {
                    String[] parts = def.split(",", 3);
                    String type = parts[0];
                    String name = parts[1];
                    String rest = parts[2];
                    Class<InstallerFactory> clazz = this.factories.get(type);
                    if (clazz == null) {
                        log.warn("Unable to get class for {}", (Object)type);
                    } else {
                        InstallerFactory ifactory = clazz.newInstance();
                        Installer installer = ifactory.createInstaller(rest);
                        this.internalAdd(name, installer);
                    }
                }
                catch (InstantiationException e) {
                    Reporter.informUser((Object)this, e);
                }
                catch (IllegalAccessException e) {
                    Reporter.informUser((Object)this, e);
                }
                def = sitemap.get(PREFIX + ++i);
            }
        }
        catch (IOException ex) {
            Reporter.informUser((Object)this, ex);
        }
    }

    public void save() {
        PropertyMap props = new PropertyMap();
        StringBuilder buf = new StringBuilder();
        int i = 1;
        for (String name : this.installers.keySet()) {
            Installer installer = this.installers.get(name);
            buf.delete(0, buf.length());
            buf.append(installer.getType());
            buf.append(',');
            buf.append(name);
            buf.append(',');
            buf.append(installer.getInstallerDefinition());
            props.put(PREFIX + i++, buf.toString());
        }
        URI outputURI = CWProject.instance().getWritableURI(this.getClass().getName(), ".plugin");
        try {
            NetUtil.storeProperties(props, outputURI, "Saved Installer Sites");
        }
        catch (IOException e) {
            log.error("Failed to save installers", (Throwable)e);
        }
    }

    public Set<String> getInstallerFactoryNames() {
        return Collections.unmodifiableSet(this.factories.keySet());
    }

    public String getFactoryNameForInstaller(Installer installer) {
        Class<?> match = installer.getClass();
        for (String name : this.factories.keySet()) {
            Class<InstallerFactory> factclazz = this.factories.get(name);
            try {
                InstallerFactory ifactory = factclazz.newInstance();
                Class<?> clazz = ifactory.createInstaller().getClass();
                if (clazz != match) continue;
                return name;
            }
            catch (InstantiationException e) {
                log.warn("Failed to instantiate installer factory: {}={}", new Object[]{name, factclazz.getName(), e});
            }
            catch (IllegalAccessException e) {
                log.warn("Failed to instantiate installer factory: {}={}", new Object[]{name, factclazz.getName(), e});
            }
        }
        log.warn("Failed to find factory name for {} among the {} factories.", (Object)installer, (Object)Integer.toString(this.factories.size()));
        return null;
    }

    public String getInstallerNameForInstaller(Installer installer) {
        Installer test;
        for (String name : this.installers.keySet()) {
            test = this.installers.get(name);
            if (!installer.equals(test)) continue;
            return name;
        }
        log.warn("Failed to find installer name for {} among the {} installers.", (Object)installer, (Object)Integer.toString(this.installers.size()));
        for (String name : this.installers.keySet()) {
            test = this.installers.get(name);
            log.warn("  it isn't equal to {}", (Object)test.getInstallerDefinition());
        }
        return null;
    }

    public InstallerFactory getInstallerFactory(String name) {
        block4: {
            Class<InstallerFactory> clazz = this.factories.get(name);
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException e) {
                assert (false) : e;
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    public Map<String, Installer> getInstallers() {
        return Collections.unmodifiableMap(this.installers);
    }

    public Installer getInstaller(String name) {
        return this.installers.get(name);
    }

    public void addInstaller(String name, Installer installer) {
        assert (installer != null);
        assert (name != null);
        this.removeInstaller(name);
        this.internalAdd(name, installer);
        this.fireInstallersChanged(this, installer, true);
    }

    private void internalAdd(String name, Installer installer) {
        Iterator<String> it = this.installers.keySet().iterator();
        while (it.hasNext()) {
            String tname = it.next();
            Installer tinstaller = this.installers.get(tname);
            if (!tinstaller.equals(installer)) continue;
            log.warn("duplicate installers: {}={}. removing {}", new Object[]{name, tname, tname});
            it.remove();
            this.fireInstallersChanged(this, tinstaller, false);
        }
        this.installers.put(name, installer);
    }

    public void removeInstaller(String name) {
        if (this.installers.containsKey(name)) {
            Installer old = this.installers.remove(name);
            this.fireInstallersChanged(this, old, false);
        }
    }

    public synchronized void addInstallerListener(InstallerListener li) {
        listeners.add(InstallerListener.class, li);
    }

    public synchronized void removeBooksListener(InstallerListener li) {
        listeners.remove(InstallerListener.class, li);
    }

    protected synchronized void fireInstallersChanged(Object source, Installer installer, boolean added) {
        Object[] contents = listeners.getListenerList();
        InstallerEvent ev = null;
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != InstallerListener.class) continue;
            if (ev == null) {
                ev = new InstallerEvent(source, installer, added);
            }
            if (added) {
                ((InstallerListener)contents[i + 1]).installerAdded(ev);
                continue;
            }
            ((InstallerListener)contents[i + 1]).installerRemoved(ev);
        }
    }
}

