/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import gnu.gpl.License;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.text.html.HTMLEditorKit;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.AntiAliasedTextPane;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.MapTableModel;
import org.crosswire.common.util.CollectionUtil;

public class AboutPane {
    private static final String SPLASH_FONT = "SanSerif";
    private static boolean advanced;
    private JDialog dlgMain;
    private JPanel pnlMain;

    public AboutPane() {
        this.init();
    }

    private void init() {
        ImageIcon icon = GuiUtil.getIcon(BDMsg.gettext("/images/splash.png", new Object[0]));
        JLabel lblPicture = new JLabel();
        lblPicture.setIcon(icon);
        lblPicture.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        lblPicture.setHorizontalAlignment(0);
        lblPicture.setVerticalAlignment(0);
        JLabel lblInfo = new JLabel();
        lblInfo.setFont(new Font(SPLASH_FONT, 1, 14));
        lblInfo.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        lblInfo.setOpaque(true);
        lblInfo.setHorizontalAlignment(11);
        lblInfo.setText(BDMsg.getVersionInfo());
        ActionFactory actions = new ActionFactory(this);
        CWAction action = actions.addAction("AboutOK", BDMsg.gettext("OK", new Object[0]));
        action.setTooltip(BDMsg.gettext("Close this window", new Object[0]));
        JButton btnOk = new JButton(action);
        JPanel pnlButtons = new JPanel();
        pnlButtons.add(btnOk);
        this.pnlMain = new JPanel();
        this.pnlMain.setLayout(new BorderLayout(5, 5));
        this.pnlMain.add((Component)pnlButtons, "South");
        this.pnlMain.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel pnlSplash = new JPanel();
        pnlSplash.setLayout(new BorderLayout(5, 0));
        pnlSplash.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlSplash.add((Component)lblPicture, "Center");
        pnlSplash.add((Component)lblInfo, "South");
        JTabbedPane tabMain = new JTabbedPane();
        this.pnlMain.add((Component)tabMain, "Center");
        String appName = BDMsg.getApplicationTitle();
        tabMain.add((Component)pnlSplash, appName);
        License license = new License(appName);
        AntiAliasedTextPane warranty = new AntiAliasedTextPane();
        warranty.setEditable(false);
        warranty.setEditorKit(new HTMLEditorKit());
        warranty.setText(license.getWarranty());
        warranty.setCaretPosition(0);
        CWScrollPane warrantyScr = new CWScrollPane(warranty);
        warrantyScr.setPreferredSize(new Dimension(500, 300));
        JPanel warrantyPnl = new JPanel(new BorderLayout());
        warrantyPnl.add((Component)warrantyScr, "Center");
        warrantyPnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tabMain.add((Component)warrantyPnl, BDMsg.gettext("Warranty", new Object[0]));
        AntiAliasedTextPane details = new AntiAliasedTextPane();
        details.setEditable(false);
        details.setEditorKit(new HTMLEditorKit());
        details.setText(license.getDetails());
        details.setCaretPosition(0);
        CWScrollPane detailScr = new CWScrollPane(details);
        detailScr.setPreferredSize(new Dimension(500, 300));
        JPanel detailsPnl = new JPanel(new BorderLayout());
        detailsPnl.add((Component)detailScr, "Center");
        detailsPnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tabMain.add((Component)detailsPnl, BDMsg.gettext("License", new Object[0]));
        if (advanced) {
            JTable tblProps = new JTable();
            MapTableModel mdlProps = new MapTableModel((Map)CollectionUtil.properties2Map((Properties)System.getProperties()));
            tblProps.setModel(mdlProps);
            CWScrollPane scrProps = new CWScrollPane(tblProps);
            scrProps.setPreferredSize(new Dimension(500, 300));
            JPanel pnlProps = new JPanel();
            pnlProps.setLayout(new BorderLayout());
            pnlProps.add((Component)scrProps, "Center");
            pnlProps.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            tabMain.add((Component)pnlProps, BDMsg.gettext("System Properties", new Object[0]));
        }
        GuiUtil.applyDefaultOrientation(this.pnlMain);
    }

    public void doAboutOK() {
        if (this.dlgMain != null) {
            this.dlgMain.dispose();
            this.dlgMain = null;
        }
    }

    public void showInDialog(Component parent) {
        Frame root = JOptionPane.getFrameForComponent(parent);
        this.dlgMain = new JDialog(root);
        this.dlgMain.getContentPane().add(this.pnlMain);
        this.dlgMain.setTitle(BDMsg.getAboutInfo());
        this.dlgMain.setModal(true);
        this.dlgMain.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent ev) {
                AboutPane.this.doAboutOK();
            }
        });
        GuiUtil.applyDefaultOrientation(this.dlgMain);
        this.dlgMain.pack();
        this.dlgMain.setLocationRelativeTo(parent);
        this.dlgMain.setVisible(true);
    }

    public static synchronized boolean isAdvanced() {
        return advanced;
    }

    public static synchronized void setAdvanced(boolean advanced) {
        AboutPane.advanced = advanced;
    }
}

