/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.Component;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.transform.TransformerException;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.common.swing.AntiAliasedTextPane;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.JDOMSAXEventProvider;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.util.ConverterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TextPaneBookMetaDataDisplay {
    private Converter converter = ConverterFactory.getConverter();
    private JTextPane txtView = new AntiAliasedTextPane();
    protected static final Logger log = LoggerFactory.getLogger(TextPaneBookMetaDataDisplay.class);

    public TextPaneBookMetaDataDisplay() {
        this.txtView.setEditable(false);
        this.txtView.setEditorKit(new HTMLEditorKit());
    }

    public void setBook(Book book) {
        if (book == null) {
            this.txtView.setText("");
            return;
        }
        try {
            JDOMSAXEventProvider osissep = new JDOMSAXEventProvider(book.toOSIS());
            TransformingSAXEventProvider htmlsep = (TransformingSAXEventProvider)this.converter.convert((SAXEventProvider)osissep);
            XSLTProperty.FONT.setProperty(htmlsep);
            String text = XMLUtil.writeToString((SAXEventProvider)htmlsep);
            this.txtView.setText(text);
            this.txtView.select(0, 0);
        }
        catch (SAXException e) {
            Reporter.informUser((Object)this, (Throwable)e);
        }
        catch (TransformerException e) {
            Reporter.informUser((Object)this, (Throwable)e);
        }
    }

    public Component getComponent() {
        return this.txtView;
    }
}

