/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.install.BookIcon;
import org.crosswire.bibledesktop.book.install.BookNode;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;

public class BookTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -942626483282049048L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        Object obj;
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, this.hasFocus);
        String tooltip = null;
        if (leaf && value instanceof BookNode && (obj = ((BookNode)value).getUserObject()) instanceof Book) {
            Book book = (Book)obj;
            this.setText(book.getName() + " (" + book.getInitials() + ")");
            this.setLeafIcon(BookIcon.getIcon(book));
            if (book.isQuestionable()) {
                tooltip = BookCategory.QUESTIONABLE.toString();
            }
            if (!book.isSupported()) {
                tooltip = BDMsg.gettext("Unsupported", new Object[0]);
            } else if (book.isLocked()) {
                tooltip = BDMsg.gettext("Locked", new Object[0]);
            }
        }
        this.setToolTipText(tooltip);
        return this;
    }
}

