/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.ReferenceSystem;
import org.crosswire.jsword.internationalisation.LocaleProviderManager;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.BibleBook;
import org.crosswire.jsword.versification.BibleBookList;
import org.crosswire.jsword.versification.BibleNames;
import org.crosswire.jsword.versification.BookName;
import org.crosswire.jsword.versification.Testament;

public class Versification
implements ReferenceSystem,
Serializable {
    private String name;
    private BibleBookList bookList;
    private int otMaxOrdinal;
    private int ntMaxOrdinal;
    private int[][] lastVerse;
    private int[][] chapterStarts;
    private transient Map<Locale, BibleNames> localizedBibleNames = new HashMap<Locale, BibleNames>();
    private static BibleNames englishBibleNames;
    private static final long serialVersionUID = -6226916242596368765L;

    public Versification() {
    }

    public Versification(String name, BibleBook[] booksOT, BibleBook[] booksNT, int[][] lastVerseOT, int[][] lastVerseNT) {
        int[] dest;
        int[] src;
        int i;
        this.name = name;
        int bookCount = 1;
        if (booksOT.length > 0) {
            bookCount += booksOT.length + 1;
        }
        int ntStart = bookCount;
        if (booksNT.length > 0) {
            bookCount += booksNT.length + 1;
        }
        BibleBook[] books = new BibleBook[bookCount];
        books[0] = BibleBook.INTRO_BIBLE;
        if (booksOT.length > 0) {
            books[1] = BibleBook.INTRO_OT;
            System.arraycopy(booksOT, 0, books, 2, booksOT.length);
        }
        if (booksNT.length > 0) {
            books[ntStart] = BibleBook.INTRO_NT;
            System.arraycopy(booksNT, 0, books, ntStart + 1, booksNT.length);
        }
        this.bookList = new BibleBookList(books);
        int ordinal = 0;
        this.lastVerse = new int[bookCount][];
        int bookIndex = 0;
        int[] chapters = new int[]{0};
        this.lastVerse[bookIndex++] = chapters;
        if (lastVerseOT.length > 0) {
            chapters = new int[]{0};
            this.lastVerse[bookIndex++] = chapters;
            for (i = 0; i < lastVerseOT.length; ++i) {
                src = lastVerseOT[i];
                dest = new int[src.length + 1];
                this.lastVerse[bookIndex++] = dest;
                dest[0] = 0;
                System.arraycopy(src, 0, dest, 1, src.length);
            }
        }
        if (lastVerseNT.length > 0) {
            chapters = new int[]{0};
            this.lastVerse[bookIndex++] = chapters;
            for (i = 0; i < lastVerseNT.length; ++i) {
                src = lastVerseNT[i];
                dest = new int[src.length + 1];
                this.lastVerse[bookIndex++] = dest;
                dest[0] = 0;
                System.arraycopy(src, 0, dest, 1, src.length);
            }
        }
        this.chapterStarts = new int[bookCount][];
        for (bookIndex = 0; bookIndex < bookCount; ++bookIndex) {
            if (this.bookList.getBook(bookIndex) == BibleBook.INTRO_NT) {
                this.otMaxOrdinal = ordinal - 1;
            }
            int[] src2 = this.lastVerse[bookIndex];
            int numChapters = src2.length;
            dest = new int[numChapters];
            this.chapterStarts[bookIndex] = dest;
            for (int chapterIndex = 0; chapterIndex < numChapters; ++chapterIndex) {
                dest[chapterIndex] = ordinal;
                ordinal += src2[chapterIndex] + 1;
            }
        }
        this.ntMaxOrdinal = ordinal - 1;
        this.initBookLookup();
    }

    public String getName() {
        return this.name;
    }

    public boolean containsBook(BibleBook book) {
        return this.bookList.contains(book);
    }

    public BibleBook getBook(int ordinal) {
        return this.bookList.getBook(ordinal);
    }

    public int getBookCount() {
        return this.bookList.getBookCount();
    }

    public BibleBook getFirstBook() {
        return this.bookList.getFirstBook();
    }

    public BibleBook getLastBook() {
        return this.bookList.getLastBook();
    }

    public BibleBook getNextBook(BibleBook book) {
        return this.bookList.getNextBook(book);
    }

    public BibleBook getPreviousBook(BibleBook book) {
        return this.bookList.getPreviousBook(book);
    }

    public Iterator<BibleBook> getBookIterator() {
        return this.bookList.iterator();
    }

    public BookName getBookName(BibleBook book) {
        return this.getLocalizedBibleNames().getBookName(book);
    }

    public String getPreferredName(BibleBook book) {
        return this.getLocalizedBibleNames().getPreferredName(book);
    }

    public String getLongName(BibleBook book) {
        return this.getLocalizedBibleNames().getLongName(book);
    }

    public String getShortName(BibleBook book) {
        return this.getLocalizedBibleNames().getShortName(book);
    }

    public BibleBook getBook(String find) {
        BibleBook book = null;
        if (Versification.containsLetter(find)) {
            book = BibleBook.fromOSIS(find);
            if (book == null) {
                book = this.getLocalizedBibleNames().getBook(find);
            }
            if (book == null && englishBibleNames != null) {
                book = englishBibleNames.getBook(find);
            }
        }
        if (this.containsBook(book)) {
            return book;
        }
        return null;
    }

    public boolean isBook(String find) {
        return this.getBook(find) != null;
    }

    public int getLastChapter(BibleBook book) {
        try {
            return this.lastVerse[this.bookList.getOrdinal(book)].length - 1;
        }
        catch (NullPointerException ex) {
            return 0;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return 0;
        }
    }

    public int getLastVerse(BibleBook book, int chapter) {
        try {
            return this.lastVerse[this.bookList.getOrdinal(book)][chapter];
        }
        catch (NullPointerException ex) {
            return 0;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return 0;
        }
    }

    public VerseRange getAllVerses() {
        Verse first = new Verse(this, this.bookList.getFirstBook(), 0, 0);
        BibleBook book = this.bookList.getLastBook();
        int chapter = this.getLastChapter(book);
        Verse last = new Verse(this, book, chapter, this.getLastVerse(book, chapter));
        return new VerseRange(this, first, last);
    }

    public boolean isIntro(Verse verse) {
        int v = verse.getVerse();
        return v == 0;
    }

    public boolean isBookIntro(Verse verse) {
        return 0 == verse.getChapter() && this.isIntro(verse);
    }

    public boolean isChapterIntro(Verse verse) {
        return 0 != verse.getChapter() && this.isIntro(verse);
    }

    public boolean isStartOfChapter(Verse verse) {
        int v = verse.getVerse();
        return v <= 1;
    }

    public boolean isEndOfChapter(Verse verse) {
        int c;
        BibleBook b = verse.getBook();
        int v = verse.getVerse();
        return v == this.getLastVerse(b, c = verse.getChapter());
    }

    public boolean isStartOfBook(Verse verse) {
        int v = verse.getVerse();
        int c = verse.getChapter();
        return v <= 1 && c <= 1;
    }

    public boolean isEndOfBook(Verse verse) {
        int c;
        BibleBook b = verse.getBook();
        int v = verse.getVerse();
        return v == this.getLastVerse(b, c = verse.getChapter()) && c == this.getLastChapter(b);
    }

    public boolean isSameChapter(Verse first, Verse second) {
        return first.getBook() == second.getBook() && first.getChapter() == second.getChapter();
    }

    public boolean isAdjacentChapter(Verse first, Verse second) {
        Verse before = this.min(first, second);
        Verse after = this.max(first, second);
        if (this.isSameBook(first, second)) {
            return after.getChapter() - before.getChapter() == 1;
        }
        return this.isAdjacentBook(before, after) && this.getLastChapter(before.getBook()) == before.getChapter() && after.getChapter() <= 1;
    }

    public boolean isSameBook(Verse first, Verse second) {
        return first.getBook() == second.getBook();
    }

    public boolean isAdjacentBook(Verse first, Verse second) {
        return Math.abs(this.bookList.getOrdinal(second.getBook()) - this.bookList.getOrdinal(first.getBook())) == 1;
    }

    public boolean isAdjacentVerse(Verse first, Verse second) {
        Verse before = this.min(first, second);
        Verse after = this.max(first, second);
        if (this.isSameChapter(first, second)) {
            return after.getVerse() - before.getVerse() == 1;
        }
        return this.isAdjacentChapter(before, after) && this.getLastVerse(before.getBook(), before.getChapter()) == before.getVerse() && after.getVerse() <= 1;
    }

    public int distance(Verse start, Verse end) {
        return end.getOrdinal() - start.getOrdinal();
    }

    public Verse min(Verse first, Verse second) {
        return first.getOrdinal() <= second.getOrdinal() ? first : second;
    }

    public Verse max(Verse first, Verse second) {
        return first.getOrdinal() > second.getOrdinal() ? first : second;
    }

    public Verse subtract(Verse verse, int n) {
        int newVerse = verse.getVerse() - n;
        if (newVerse >= 0) {
            return new Verse(verse.getVersification(), verse.getBook(), verse.getChapter(), newVerse);
        }
        return this.decodeOrdinal(verse.getOrdinal() - n);
    }

    public Verse next(Verse verse) {
        if (verse.getOrdinal() == this.ntMaxOrdinal) {
            return null;
        }
        BibleBook nextBook = verse.getBook();
        int nextChapter = verse.getChapter();
        int nextVerse = verse.getVerse() + 1;
        if (nextVerse > this.getLastVerse(nextBook, nextChapter)) {
            nextVerse = 0;
            if (++nextChapter > this.getLastChapter(nextBook)) {
                nextChapter = 0;
                nextBook = this.bookList.getNextBook(verse.getBook());
            }
        }
        if (nextBook == null) {
            assert (false);
            return null;
        }
        return new Verse(this, nextBook, nextChapter, nextVerse);
    }

    public Verse add(Verse verse, int n) {
        int newVerse = verse.getVerse() + n;
        if (newVerse <= this.getLastVerse(verse.getBook(), verse.getChapter())) {
            return new Verse(verse.getVersification(), verse.getBook(), verse.getChapter(), newVerse);
        }
        return this.decodeOrdinal(verse.getOrdinal() + n);
    }

    public int getChapterCount(Verse start, Verse end) {
        BibleBook startBook = start.getBook();
        int startChap = start.getChapter();
        BibleBook endBook = end.getBook();
        int endChap = end.getChapter();
        if (startBook == endBook) {
            return endChap - startChap + 1;
        }
        int total = this.getLastChapter(startBook) - startChap;
        startBook = this.bookList.getNextBook(startBook);
        endBook = this.bookList.getPreviousBook(endBook);
        BibleBook b = startBook;
        while (b != endBook) {
            total += this.getLastChapter(b);
            b = this.bookList.getNextBook(b);
        }
        return total += endChap;
    }

    public int getBookCount(Verse start, Verse end) {
        int startBook = this.bookList.getOrdinal(start.getBook());
        int endBook = this.bookList.getOrdinal(end.getBook());
        return endBook - startBook + 1;
    }

    public int maximumOrdinal() {
        return this.ntMaxOrdinal;
    }

    public int getOrdinal(Verse verse) {
        try {
            return this.chapterStarts[this.bookList.getOrdinal(verse.getBook())][verse.getChapter()] + verse.getVerse();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    public int getTestamentOrdinal(int ordinal) {
        int nt_ordinal = this.otMaxOrdinal + 1;
        if (ordinal >= nt_ordinal) {
            return ordinal - nt_ordinal + 1;
        }
        return ordinal;
    }

    public Testament getTestament(int ordinal) {
        if (ordinal > this.otMaxOrdinal) {
            return Testament.NEW;
        }
        return Testament.OLD;
    }

    public int getCount(Testament testament) {
        int total = this.ntMaxOrdinal + 1;
        if (testament == null) {
            return total;
        }
        int otCount = this.otMaxOrdinal + 1;
        if (testament == Testament.OLD) {
            return otCount;
        }
        return total - otCount;
    }

    public Verse decodeOrdinal(int ordinal) {
        int ord = ordinal;
        if (ord < 0) {
            ord = 0;
        } else if (ord > this.ntMaxOrdinal) {
            ord = this.ntMaxOrdinal;
        }
        if (ord == 0) {
            return new Verse(this, BibleBook.INTRO_BIBLE, 0, 0);
        }
        if (ord == 1) {
            return new Verse(this, BibleBook.INTRO_OT, 0, 0);
        }
        if (ord == this.otMaxOrdinal + 1) {
            return new Verse(this, BibleBook.INTRO_NT, 0, 0);
        }
        int low = 0;
        int high = this.chapterStarts.length;
        int match = -1;
        while (high - low > 1) {
            int mid = low + high >>> 1;
            int cmp = this.chapterStarts[mid][0] - ord;
            if (cmp < 0) {
                low = mid;
                continue;
            }
            if (cmp > 0) {
                high = mid;
                continue;
            }
            match = mid;
            break;
        }
        int bookIndex = match >= 0 ? match : low;
        BibleBook book = this.bookList.getBook(bookIndex);
        low = 0;
        high = this.chapterStarts[bookIndex].length;
        match = -1;
        while (high - low > 1) {
            int mid = low + high >>> 1;
            int cmp = this.chapterStarts[bookIndex][mid] - ord;
            if (cmp < 0) {
                low = mid;
                continue;
            }
            if (cmp > 0) {
                high = mid;
                continue;
            }
            match = mid;
            break;
        }
        int chapterIndex = match >= 0 ? match : low;
        int verse = chapterIndex == 0 ? 0 : ord - this.chapterStarts[bookIndex][chapterIndex];
        return new Verse(this, book, chapterIndex, verse);
    }

    public void validate(BibleBook book, int chapter, int verse) throws NoSuchVerseException {
        if (book == null) {
            throw new NoSuchVerseException(JSOtherMsg.lookupText("Book must not be null", new Object[0]));
        }
        int maxChapter = this.getLastChapter(book);
        if (chapter < 0 || chapter > maxChapter) {
            throw new NoSuchVerseException(JSMsg.gettext("Chapter should be between {0} and {1,number,integer} for {2} (given {3,number,integer}).", 0, maxChapter, this.getPreferredName(book), chapter));
        }
        int maxVerse = this.getLastVerse(book, chapter);
        if (verse < 0 || verse > maxVerse) {
            throw new NoSuchVerseException(JSMsg.gettext("Verse should be between {0} and {1,number,integer} for {2} {3,number,integer} (given {4,number,integer}).", 0, maxVerse, this.getPreferredName(book), chapter, verse));
        }
    }

    public Verse patch(BibleBook book, int chapter, int verse) {
        BibleBook patchedBook = book;
        int patchedChapter = chapter;
        int patchedVerse = verse;
        if (patchedBook == null) {
            patchedBook = this.bookList.getFirstBook();
        }
        if (patchedChapter < 0) {
            patchedChapter = 0;
        }
        if (patchedVerse < 0) {
            patchedVerse = 0;
        }
        while (patchedBook != null && patchedChapter > this.getLastChapter(patchedBook)) {
            patchedChapter -= this.getLastChapter(patchedBook) + 1;
            patchedBook = this.bookList.getNextBook(patchedBook);
        }
        while (patchedBook != null && patchedVerse > this.getLastVerse(patchedBook, patchedChapter)) {
            patchedVerse -= this.getLastVerse(patchedBook, patchedChapter) + 1;
            if (++patchedChapter <= this.getLastChapter(patchedBook)) continue;
            patchedChapter -= this.getLastChapter(patchedBook) + 1;
            patchedBook = this.bookList.getNextBook(patchedBook);
        }
        if (patchedBook == null) {
            patchedBook = this.bookList.getLastBook();
            patchedChapter = this.getLastChapter(patchedBook);
            patchedVerse = this.getLastVerse(patchedBook, patchedChapter);
        }
        return new Verse(this, patchedBook, patchedChapter, patchedVerse);
    }

    public static void dump(PrintStream out, String name, BibleBookList bookList, int[][] array) {
        String vstr1 = "";
        String vstr2 = "";
        int count = 0;
        out.println("    private final int[][] " + name + " =");
        out.println("    {");
        int bookCount = array.length;
        for (int bookIndex = 0; bookIndex < bookCount; ++bookIndex) {
            count = 0;
            out.print("        // ");
            if (bookIndex < bookList.getBookCount()) {
                BibleBook book = bookList.getBook(bookIndex);
                out.println(book.getOSIS());
            } else {
                out.println("Sentinel");
            }
            out.print("        { ");
            int numChapters = array[bookIndex].length;
            for (int chapterIndex = 0; chapterIndex < numChapters; ++chapterIndex) {
                if (count++ % 10 == 0) {
                    out.println();
                    out.print("            ");
                }
                vstr1 = "     " + array[bookIndex][chapterIndex];
                vstr2 = vstr1.substring(vstr1.length() - 5);
                out.print(vstr2 + ", ");
            }
            out.println();
            out.println("        },");
        }
        out.println("    };");
    }

    public static void optimize(PrintStream out, BibleBookList bookList, int[][] lastVerse) {
        String vstr1 = "";
        String vstr2 = "";
        int count = 0;
        int ordinal = 0;
        out.println("    private final int[][] chapterStarts =");
        out.println("    {");
        int bookIndex = 0;
        int ntStartOrdinal = 0;
        BibleBook book = bookList.getBook(0);
        while (book != null) {
            count = 0;
            out.print("        // ");
            out.println(book.getOSIS());
            out.print("        { ");
            if (book == BibleBook.INTRO_NT) {
                ntStartOrdinal = ordinal;
            }
            int numChapters = lastVerse[bookIndex].length;
            for (int chapterIndex = 0; chapterIndex < numChapters; ++chapterIndex) {
                if (count++ % 10 == 0) {
                    out.println();
                    out.print("            ");
                }
                vstr1 = "     " + ordinal;
                vstr2 = vstr1.substring(vstr1.length() - 5);
                out.print(vstr2 + ", ");
                int versesInChapter = lastVerse[bookIndex][chapterIndex] + 1;
                ordinal += versesInChapter;
            }
            out.println();
            out.println("        },");
            ++bookIndex;
            book = bookList.getNextBook(book);
        }
        vstr1 = "     " + ordinal;
        vstr2 = vstr1.substring(vstr1.length() - 5);
        out.println("        // Sentinel");
        out.println("        { ");
        out.println("            " + vstr2 + ", ");
        out.println("        },");
        out.println("    };");
        out.println();
        out.println("    /** The last ordinal number of the Old Testament */");
        out.println("    private int otMaxOrdinal = " + (ntStartOrdinal - 1) + ";");
        out.println("    /** The last ordinal number of the New Testament and the maximum ordinal number of this Reference System */");
        out.println("    private int ntMaxOrdinal = " + (ordinal - 1) + ";");
    }

    private BibleNames getLocalizedBibleNames() {
        return this.getBibleNamesForLocale(LocaleProviderManager.getLocale());
    }

    private BibleNames getBibleNamesForLocale(Locale locale) {
        BibleNames bibleNames = this.localizedBibleNames.get(locale);
        if (bibleNames == null) {
            bibleNames = new BibleNames(this, locale);
            this.localizedBibleNames.put(locale, bibleNames);
        }
        return bibleNames;
    }

    private void initBookLookup() {
        englishBibleNames = this.getBibleNamesForLocale(Locale.ENGLISH);
    }

    private static boolean containsLetter(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isLetter(text.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

