/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.util.Collections;
import java.util.List;
import org.crosswire.common.util.CollectionUtil;
import org.crosswire.common.util.EventListenerList;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilterIterator;
import org.crosswire.jsword.book.BookList;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;

public abstract class AbstractBookList
implements BookList {
    private static EventListenerList listeners = new EventListenerList();

    @Override
    public List<Book> getBooks(BookFilter filter) {
        List<Book> temp = CollectionUtil.createList(new BookFilterIterator(this.getBooks(), filter));
        return Collections.unmodifiableList(temp);
    }

    @Override
    public synchronized void addBooksListener(BooksListener li) {
        listeners.add(BooksListener.class, li);
    }

    @Override
    public synchronized void removeBooksListener(BooksListener li) {
        listeners.remove(BooksListener.class, li);
    }

    protected static synchronized void fireBooksChanged(Object source, Book book, boolean added) {
        Object[] contents = listeners.getListenerList();
        BooksEvent ev = null;
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != BooksListener.class) continue;
            if (ev == null) {
                ev = new BooksEvent(source, book, added);
            }
            if (added) {
                ((BooksListener)contents[i + 1]).bookAdded(ev);
                continue;
            }
            ((BooksListener)contents[i + 1]).bookRemoved(ev);
        }
    }
}

