/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.display.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.EventListenerList;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.passage.KeyChangeListener;
import org.crosswire.bibledesktop.passage.KeySidebar;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookProvider;
import org.crosswire.jsword.passage.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitBookDataDisplay
extends JPanel
implements BookProvider {
    private KeySidebar sidebar;
    private JSplitPane split;
    private transient BookDataDisplay child;
    private static final Logger log = LoggerFactory.getLogger(SplitBookDataDisplay.class);
    private static final long serialVersionUID = 3257283643176202806L;

    public SplitBookDataDisplay(KeySidebar sidebar, BookDataDisplay child) {
        this.child = child;
        this.sidebar = sidebar;
        this.listenerList = new EventListenerList();
        this.split = new FixedSplitPane();
        this.split.setOrientation(1);
        this.split.setLeftComponent(sidebar);
        this.split.setRightComponent(child.getComponent());
        this.split.setOneTouchExpandable(true);
        this.split.setDividerLocation(0.0);
        this.split.setBorder(null);
        this.split.setDividerSize(8);
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public KeySidebar getSidebar() {
        return this.sidebar;
    }

    public BookDataDisplay getBookDataDisplay() {
        return this.child;
    }

    public void setBookData(Book[] books, Key key) {
        boolean bookChanged;
        boolean keyChanged = this.child.getKey() == null || !this.child.getKey().equals(key);
        boolean bl = bookChanged = this.child.getBooks() == null || !Arrays.equals(this.child.getBooks(), books);
        if (keyChanged) {
            log.debug("new passage chosen: {}", (Object)key.getName());
        }
        if (bookChanged) {
            log.debug("new book(s) chosen: {}", (Object)Arrays.toString(books));
        }
        if (bookChanged || keyChanged) {
            this.child.setBookData(books, key);
        }
    }

    public void showSidebar(boolean show) {
        Component childComponent = this.child.getComponent();
        if (show) {
            this.remove(childComponent);
            this.split.add(childComponent, "right");
            this.add(this.split);
        } else {
            this.remove(this.split);
            this.split.remove(childComponent);
            this.add(childComponent);
        }
        this.validate();
    }

    public Key getKey() {
        return this.child.getKey();
    }

    public Book[] getBooks() {
        return this.child.getBooks();
    }

    public Book getFirstBook() {
        return this.child.getFirstBook();
    }

    public void copy() {
        this.child.copy();
    }

    public synchronized void addKeyChangeListener(KeyChangeListener listener) {
        this.child.addKeyChangeListener(listener);
    }

    public synchronized void removeKeyChangeListener(KeyChangeListener listener) {
        this.child.removeKeyChangeListener(listener);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.child = null;
        is.defaultReadObject();
    }
}

