/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.util.CollectionUtil;
import org.crosswire.common.util.PluginUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.AbstractBookList;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilterIterator;
import org.crosswire.jsword.book.BookFilters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Books
extends AbstractBookList {
    private Set<Book> books;
    private Map<String, Book> initials = new HashMap<String, Book>();
    private Map<String, Book> names = new HashMap<String, Book>();
    private Set<BookDriver> drivers = new HashSet<BookDriver>();
    private static final Logger log = LoggerFactory.getLogger(Books.class);
    private static final Books instance = new Books();

    private Books() {
        this.books = new TreeSet<Book>();
    }

    public static Books installed() {
        return instance;
    }

    @Override
    public synchronized List<Book> getBooks() {
        return CollectionUtil.createList(this.books);
    }

    @Override
    public synchronized List<Book> getBooks(BookFilter filter) {
        return CollectionUtil.createList(new BookFilterIterator(this.books, filter));
    }

    public synchronized Book getBook(String name) {
        if (name == null) {
            return null;
        }
        Book book = this.initials.get(name);
        if (book != null) {
            return book;
        }
        book = this.names.get(name);
        if (book != null) {
            return book;
        }
        for (Book b : this.books) {
            if (!name.equalsIgnoreCase(b.getInitials()) && !name.equalsIgnoreCase(b.getName())) continue;
            return b;
        }
        return null;
    }

    public synchronized void addBook(Book book) {
        if (book != null && this.books.add(book)) {
            this.initials.put(book.getInitials(), book);
            this.names.put(book.getName(), book);
            this.fireBooksChanged(instance, book, true);
        }
    }

    public synchronized void removeBook(Book book) throws BookException {
        Activator.deactivate(book);
        boolean removed = this.books.remove(book);
        if (!removed) {
            throw new BookException(JSOtherMsg.lookupText("Could not remove unregistered Book: {0}", book.getName()));
        }
        this.initials.remove(book.getInitials());
        this.names.remove(book.getName());
        this.fireBooksChanged(instance, book, false);
    }

    public synchronized void registerDriver(BookDriver driver) throws BookException {
        log.debug("begin registering driver: {}", (Object)driver.getClass().getName());
        this.drivers.add(driver);
        Book[] bookArray = driver.getBooks();
        Set<Book> current = CollectionUtil.createSet(new BookFilterIterator(this.books, BookFilters.getBooksByDriver(driver)));
        for (int j = 0; j < bookArray.length; ++j) {
            Book b = bookArray[j];
            if (current.contains(b)) {
                current.remove(b);
                continue;
            }
            this.addBook(bookArray[j]);
        }
        for (Book book : current) {
            this.removeBook(book);
        }
        log.debug("end registering driver: {}", (Object)driver.getClass().getName());
    }

    public synchronized BookDriver[] getDriversByClass(Class<? extends BookDriver> type) {
        ArrayList<BookDriver> matches = new ArrayList<BookDriver>();
        for (BookDriver driver : this.drivers) {
            if (driver.getClass() != type) continue;
            matches.add(driver);
        }
        return matches.toArray(new BookDriver[matches.size()]);
    }

    public synchronized BookDriver[] getDrivers() {
        return this.drivers.toArray(new BookDriver[this.drivers.size()]);
    }

    private void autoRegister() {
        Class<BookDriver>[] types = PluginUtil.getImplementors(BookDriver.class);
        log.debug("begin auto-registering {} drivers:", (Object)Integer.toString(types.length));
        for (int i = 0; i < types.length; ++i) {
            try {
                Method driverInstance = types[i].getMethod("instance", new Class[0]);
                BookDriver driver = (BookDriver)driverInstance.invoke(null, new Object[0]);
                this.registerDriver(driver);
                continue;
            }
            catch (NoSuchMethodException e) {
                Reporter.informUser(Books.class, e);
                continue;
            }
            catch (IllegalArgumentException e) {
                Reporter.informUser(Books.class, e);
                continue;
            }
            catch (IllegalAccessException e) {
                Reporter.informUser(Books.class, e);
                continue;
            }
            catch (InvocationTargetException e) {
                Reporter.informUser(Books.class, e);
                continue;
            }
            catch (BookException e) {
                Reporter.informUser(Books.class, e);
            }
        }
    }

    static {
        log.trace("Auto-registering start @ {}", (Object)Long.toString(System.currentTimeMillis()));
        instance.autoRegister();
        log.trace("Auto-registering stop @ {}", (Object)Long.toString(System.currentTimeMillis()));
    }
}

