/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.crosswire.common.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IniSection
implements Iterable {
    private String name;
    private Map<String, List<String>> section;
    private File configFile;
    private String charset;
    private StringBuilder warnings;
    private String report;
    private static final int MAX_BUFF_SIZE = 2048;

    public IniSection() {
        this((String)null);
    }

    public IniSection(String name) {
        this.name = name;
        this.section = new HashMap<String, List<String>>();
        this.warnings = new StringBuilder();
    }

    public IniSection(IniSection config) {
        this.name = config.getName();
        this.section = new HashMap<String, List<String>>();
        for (String key : config.getKeys()) {
            for (String value : config.getValues(key)) {
                this.add(key, value);
            }
        }
    }

    public void clear() {
        this.section.clear();
        this.warnings.setLength(0);
        this.warnings.trimToSize();
        this.report = "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.section.size();
    }

    public int size(String key) {
        Collection values = this.section.get(key);
        return values == null ? 0 : values.size();
    }

    public boolean isEmpty() {
        return this.section.isEmpty();
    }

    public Iterator iterator() {
        return this.section.keySet().iterator();
    }

    public Collection<String> getKeys() {
        return Collections.unmodifiableSet(this.section.keySet());
    }

    public boolean containsKey(String key) {
        return this.section.containsKey(key);
    }

    public boolean containsValue(String value) {
        for (List<String> collection : this.section.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(String key, String value) {
        Collection values = this.section.get(key);
        return values != null && values.contains(value);
    }

    public boolean add(String key, String value) {
        if (!this.allowed(key, value)) {
            return false;
        }
        Collection<String> values = this.getOrCreateValues(key);
        if (values.contains(value)) {
            this.warnings.append("Duplicate value: ").append(key).append(" = ").append(value).append('\n');
            return true;
        }
        return values.add(value);
    }

    public Collection<String> getValues(String key) {
        if (this.section.containsKey(key)) {
            return Collections.unmodifiableCollection((Collection)this.section.get(key));
        }
        return null;
    }

    public String get(String key, int index) {
        List<String> values = this.section.get(key);
        return values == null ? null : values.get(index);
    }

    public String get(String key) {
        List<String> values = this.section.get(key);
        return values == null ? null : values.get(0);
    }

    public String get(String key, String defaultValue) {
        List<String> values = this.section.get(key);
        return values == null ? defaultValue : values.get(0);
    }

    public boolean remove(String key, String value) {
        Collection values = this.section.get(key);
        if (values == null) {
            return false;
        }
        boolean changed = values.remove(value);
        if (changed && values.isEmpty()) {
            this.section.remove(key);
        }
        return changed;
    }

    public boolean remove(String key) {
        Collection values = this.section.get(key);
        if (values == null) {
            return false;
        }
        this.section.remove(key);
        return true;
    }

    public boolean replace(String key, String value) {
        if (!this.allowed(key, value)) {
            return false;
        }
        Collection<String> values = this.getOrCreateValues(key);
        values.clear();
        return values.add(value);
    }

    public void load(InputStream is, String encoding) throws IOException {
        this.load(is, encoding, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream is, String encoding, Filter<String> filter) throws IOException {
        InputStreamReader in = null;
        try {
            in = new InputStreamReader(is, encoding);
            this.doLoad(in, filter);
        }
        finally {
            if (in != null) {
                ((Reader)in).close();
                in = null;
            }
        }
    }

    public void load(File file, String encoding) throws IOException {
        this.load(file, encoding, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file, String encoding, Filter<String> filter) throws IOException {
        this.configFile = file;
        this.charset = encoding;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.load(in, encoding, filter);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
                in = null;
            }
        }
    }

    public void load(byte[] buffer, String encoding) throws IOException {
        this.load(buffer, encoding, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(byte[] buffer, String encoding, Filter<String> filter) throws IOException {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(buffer);
            this.load(in, encoding, filter);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
                in = null;
            }
        }
    }

    public void save() throws IOException {
        assert (this.configFile != null);
        assert (this.charset != null);
        if (this.configFile != null && this.charset != null) {
            this.save(this.configFile, this.charset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, String encoding) throws IOException {
        this.configFile = file;
        this.charset = encoding;
        Writer out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
            this.save(out);
        }
        finally {
            if (out != null) {
                out.close();
                out = null;
            }
        }
    }

    public void save(Writer out) {
        PrintWriter writer = null;
        writer = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        writer.print("[");
        writer.print(this.name);
        writer.print("]");
        writer.println();
        boolean first = true;
        for (String key : this.section.keySet()) {
            Collection values = this.section.get(key);
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                if (!first) {
                    writer.println();
                    first = false;
                }
                String value = (String)iter.next();
                writer.print(key);
                writer.print(" = ");
                writer.print(this.format(value));
                writer.println();
            }
        }
        writer.flush();
    }

    public String report() {
        String str = this.report;
        this.report = "";
        return str;
    }

    private String format(String value) {
        return value.replaceAll("\n", " \\\\\n\t");
    }

    private Collection<String> getOrCreateValues(String key) {
        List<String> values = this.section.get(key);
        if (values == null) {
            values = new ArrayList<String>();
            this.section.put(key, values);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoad(Reader in, Filter<String> filter) throws IOException {
        BufferedReader bin = null;
        try {
            String line;
            bin = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in, 2048);
            while ((line = this.advance(bin)) != null) {
                if (this.isSectionLine(line)) {
                    this.name = line.substring(1, line.length() - 1);
                    continue;
                }
                int splitPos = this.getSplitPos(line);
                if (splitPos < 0) {
                    this.warnings.append("Skipping: Expected to see '=' in: ").append(line).append('\n');
                    continue;
                }
                String key = line.substring(0, splitPos).trim();
                String value = this.more(bin, line.substring(splitPos + 1).trim());
                if (filter != null && !filter.test(key)) continue;
                this.add(key, value);
            }
            this.report = this.warnings.toString();
            this.warnings.setLength(0);
            this.warnings.trimToSize();
        }
        finally {
            if (bin != null) {
                bin.close();
                bin = null;
            }
        }
    }

    private String advance(BufferedReader bin) throws IOException {
        String trimmed = null;
        String line = bin.readLine();
        while (line != null) {
            trimmed = line.trim();
            if (!this.isCommentLine(trimmed)) {
                return trimmed;
            }
            line = bin.readLine();
        }
        return null;
    }

    private boolean isCommentLine(String line) {
        if (line == null) {
            return false;
        }
        if (line.length() == 0) {
            return true;
        }
        char firstChar = line.charAt(0);
        return firstChar == ';' || firstChar == '#';
    }

    private boolean isSectionLine(String line) {
        return line.charAt(0) == '[' && line.charAt(line.length() - 1) == ']';
    }

    private int getSplitPos(String line) {
        return line.indexOf(61);
    }

    private String more(BufferedReader bin, String value) throws IOException {
        boolean moreCowBell = false;
        String line = value;
        StringBuilder buf = new StringBuilder();
        do {
            if (moreCowBell = IniSection.more(line)) {
                line = line.substring(0, line.length() - 1).trim();
            }
            buf.append(line);
            if (!moreCowBell) continue;
            buf.append('\n');
            line = this.advance(bin);
            int splitPos = this.getSplitPos(line);
            if (splitPos < 0) continue;
            this.warnings.append("Possible trailing continuation on previous line. Found: ").append(line).append('\n');
        } while (moreCowBell && line != null);
        String cowBell = buf.toString();
        buf = null;
        line = null;
        return cowBell;
    }

    private static boolean more(String line) {
        int length = line.length();
        return length > 0 && line.charAt(length - 1) == '\\';
    }

    private boolean allowed(String key, String value) {
        if (key == null || key.length() == 0 || value == null) {
            if (key == null) {
                this.warnings.append("Null keys not allowed: ").append(" = ").append(value).append('\n');
            } else if (key.length() == 0) {
                this.warnings.append("Empty keys not allowed: ").append(" = ").append(value).append('\n');
            }
            if (value == null) {
                this.warnings.append("Null values are not allowed: ").append(key).append(" = ").append('\n');
            }
            return false;
        }
        return true;
    }
}

