/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.PropertyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T> List<T> createList(Iterable<T> it) {
        ArrayList<T> reply = new ArrayList<T>();
        for (T obj : it) {
            reply.add(obj);
        }
        return reply;
    }

    public static <T> Set<T> createSet(Iterable<T> it) {
        HashSet<T> reply = new HashSet<T>();
        for (T obj : it) {
            reply.add(obj);
        }
        return reply;
    }

    public static PropertyMap properties2Map(Properties prop) {
        PropertyMap propMap = new PropertyMap();
        Enumeration<Object> e = prop.keys();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            Object v = prop.get(k);
            if (!(k instanceof String) || !(v instanceof String)) continue;
            propMap.put((String)k, (String)v);
        }
        return propMap;
    }

    public static PropertyMap properties2Map(URI propUri) throws IOException {
        return NetUtil.loadProperties(propUri);
    }
}

