/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.desktop.Titleable;
import org.crosswire.common.swing.desktop.ViewVisitor;
import org.crosswire.common.swing.desktop.Viewable;
import org.crosswire.common.swing.desktop.event.ViewEvent;
import org.crosswire.common.swing.desktop.event.ViewEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractViewLayout
implements Viewable {
    private List<Component> views;
    private EventListenerList listenerList = new EventListenerList();
    private static final int MAX_TITLE_LEN = 30;
    private static int base = 1;
    private JPanel panel = new JPanel(new BorderLayout());

    protected AbstractViewLayout() {
        GuiUtil.applyDefaultOrientation(this.panel);
        this.views = new ArrayList<Component>();
        this.listenerList = new EventListenerList();
    }

    @Override
    public void addView(Component component) {
        this.views.add(component);
    }

    @Override
    public void removeView(Component component) {
        this.views.remove(component);
        this.fireViewRemoved(new ViewEvent(component));
    }

    protected void forceRemoveView(Component component) {
        this.views.remove(component);
    }

    @Override
    public Collection<Component> getViews() {
        return new ArrayList<Component>(this.views);
    }

    @Override
    public Iterator<Component> iterator() {
        return this.getViews().iterator();
    }

    @Override
    public void moveTo(AbstractViewLayout other) {
        if (this.getClass() == other.getClass()) {
            return;
        }
        for (Component view : this) {
            this.forceRemoveView(view);
            other.addView(view);
        }
    }

    @Override
    public void closeAll() {
        for (Component view : this) {
            this.removeView(view);
        }
    }

    @Override
    public void closeOthers(Component component) {
        for (Component view : this) {
            if (view == component) continue;
            this.removeView(view);
        }
    }

    @Override
    public void visit(ViewVisitor visitor) {
        for (Component view : this) {
            visitor.visitView(view);
        }
    }

    @Override
    public abstract void updateTitle(Component var1);

    @Override
    public abstract Component getSelected();

    @Override
    public abstract void select(Component var1);

    @Override
    public int getViewCount() {
        return this.views.size();
    }

    @Override
    public Component getView(int i) {
        return this.views.get(i);
    }

    protected String getTitle(Component component) {
        if (component instanceof Titleable) {
            Titleable view = (Titleable)((Object)component);
            String title = view.getTitle();
            if (title != null && title.length() > 0) {
                if (title.length() <= 30) {
                    return title;
                }
                return title.substring(0, 27) + "...";
            }
            return this.generateTitle();
        }
        return this.generateTitle();
    }

    private String generateTitle() {
        return BDMsg.gettext("Untitled {0}", base++);
    }

    protected JPanel getPanel() {
        return this.panel;
    }

    protected Object getConstraint() {
        return null;
    }

    @Override
    public synchronized void addViewEventListener(ViewEventListener listener) {
        this.listenerList.add(ViewEventListener.class, listener);
    }

    @Override
    public synchronized void removeViewEventListener(ViewEventListener listener) {
        this.listenerList.remove(ViewEventListener.class, listener);
    }

    public void fireViewRemoved(ViewEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ViewEventListener.class) continue;
            ((ViewEventListener)listeners[i + 1]).viewRemoved(e);
        }
    }
}

