/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Button;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.text.JTextComponent;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuiUtil {
    private static final Logger log = LoggerFactory.getLogger(GuiUtil.class);

    private GuiUtil() {
    }

    public static ImageIcon getIcon(String name) {
        if (name == null || name.length() < 5) {
            return null;
        }
        try {
            URL url = ResourceUtil.getResource((String)name);
            return new ImageIcon(url);
        }
        catch (MissingResourceException ex) {
            log.error("Failed to find icon name='{}'", (Object)name, (Object)ex);
            return null;
        }
    }

    public static Window getWindow(Component com) {
        Component temp = com;
        if (temp == null) {
            return GuiUtil.getRootFrame();
        }
        while (!(temp instanceof Frame) && !(temp instanceof Dialog)) {
            if ((temp = temp.getParent()) != null) continue;
            return GuiUtil.getRootFrame();
        }
        return (Window)temp;
    }

    public static Frame getRootFrame() {
        return GuiUtil.getFrame(null);
    }

    public static Frame getFrame(Component parent) {
        if (parent == null) {
            Frame option = JOptionPane.getRootFrame();
            if (!option.getClass().getName().startsWith("javax.swing.SwingUtilities$")) {
                return option;
            }
            Frame best = null;
            int bestSize = 0;
            Frame[] frames = Frame.getFrames();
            for (int i = 0; i < frames.length; ++i) {
                Frame frame = frames[i];
                if (!frame.isVisible()) continue;
                int thisSize = frame.getWidth() * frame.getHeight();
                if (best != null && thisSize <= bestSize) continue;
                best = frame;
                bestSize = thisSize;
            }
            if (best != null) {
                return best;
            }
            return option;
        }
        if (parent instanceof Frame) {
            return (Frame)parent;
        }
        return GuiUtil.getFrame(parent.getParent());
    }

    public static Dialog getDialog(Component com) {
        Component temp = com;
        while (!(temp instanceof Dialog)) {
            if ((temp = temp.getParent()) != null) continue;
            return null;
        }
        return (Dialog)temp;
    }

    public static void centerOnScreen(Window win) {
        win.setLocationRelativeTo(null);
    }

    public static int setSize(Window win, Dimension requestedDim) {
        Dimension honoredDim = (Dimension)requestedDim.clone();
        Toolkit tk = win.getToolkit();
        Dimension originalDim = win.getSize();
        Dimension screenDim = tk.getScreenSize();
        boolean isFrame = win instanceof Frame;
        int honoredState = 0;
        if (honoredDim.width >= screenDim.width) {
            honoredDim.width = screenDim.width;
        }
        if (honoredDim.height >= screenDim.height) {
            honoredDim.height = screenDim.height;
        }
        if (isFrame && honoredDim.equals(screenDim) && tk.isFrameStateSupported(6)) {
            honoredState |= 6;
        }
        if (!honoredDim.equals(originalDim)) {
            win.setSize(honoredDim);
        }
        if (honoredState != 0 && win instanceof Frame) {
            Frame frame = (Frame)win;
            frame.setExtendedState(honoredState | frame.getExtendedState());
        }
        Dimension finalDim = win.getSize();
        honoredDim.width = finalDim.width;
        honoredDim.height = finalDim.height;
        log.warn("Window size was: {} is: {}", (Object)requestedDim, (Object)honoredDim);
        return honoredState;
    }

    public static void setSize(Window win, float percentOfScreen) {
        Toolkit tk = win.getToolkit();
        Dimension screenSize = tk.getScreenSize();
        int width = Float.valueOf((float)screenSize.width * percentOfScreen).intValue();
        int height = Float.valueOf((float)screenSize.height * percentOfScreen).intValue();
        Dimension winSize = new Dimension(width, height);
        win.setSize(winSize);
    }

    public static void defaultDesktopSize(Window win) {
        float defaultPercent = 0.75f;
        GuiUtil.setSize(win, defaultPercent);
    }

    public static void maximizeWindow(Window win) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (win instanceof Frame && tk.isFrameStateSupported(6)) {
            Frame frame = (Frame)win;
            frame.setExtendedState(6 | frame.getExtendedState());
        } else {
            Dimension screenDim = tk.getScreenSize();
            win.setLocation(0, 0);
            win.setSize(screenDim);
        }
    }

    public static void refresh(Component c) {
        c.invalidate();
        c.validate();
        c.repaint();
        if (c instanceof JComponent) {
            ((JComponent)c).revalidate();
        }
    }

    public static void restrainedRePack(Window win) {
        Dimension orig = win.getSize();
        Dimension max = new Dimension((int)((double)orig.width * 1.1), (int)((double)orig.height * 1.1));
        Dimension min = new Dimension((int)((double)orig.width / 1.1), (int)((double)orig.height / 1.1));
        win.pack();
        if (win.getSize().width > max.width) {
            win.setSize(max.width, win.getSize().height);
        }
        if (win.getSize().height > max.height) {
            win.setSize(win.getSize().width, max.height);
        }
        if (win.getSize().width < min.width) {
            win.setSize(min.width, win.getSize().height);
        }
        if (win.getSize().height < min.height) {
            win.setSize(win.getSize().width, min.height);
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        if (screenDim.width < win.getSize().width) {
            win.setSize(screenDim.width, win.getSize().height);
        }
        if (screenDim.height < win.getSize().height) {
            win.setSize(win.getSize().width, screenDim.height);
        }
        GuiUtil.refresh(win);
    }

    public static void restrainedPack(Window win, float maxx, float maxy) {
        win.pack();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        if ((float)win.getSize().width > (float)screenDim.width * maxx) {
            win.setSize((int)((float)screenDim.width * maxx), win.getSize().height);
        }
        if ((float)win.getSize().height > (float)screenDim.height * maxy) {
            win.setSize(win.getSize().width, (int)((float)screenDim.height * maxy));
        }
        GuiUtil.refresh(win);
    }

    public static void enforceMinimumSize(Component comp, int minWidth, int minHeight) {
        if (comp.getSize().width < minWidth) {
            comp.setSize(minWidth, comp.getSize().height);
        }
        if (comp.getSize().height < minHeight) {
            comp.setSize(comp.getSize().width, minHeight);
        }
    }

    public static String getText(Component comp) {
        JScrollPane scr;
        Component sub;
        if (comp instanceof JTextComponent) {
            return ((JTextComponent)comp).getText();
        }
        if (comp instanceof JLabel) {
            return ((JLabel)comp).getText();
        }
        if (comp instanceof AbstractButton) {
            return ((AbstractButton)comp).getText();
        }
        if (comp instanceof JComboBox) {
            return ((JComboBox)comp).getSelectedItem().toString();
        }
        if (comp instanceof JToolTip) {
            return ((JToolTip)comp).getTipText();
        }
        if (comp instanceof TextComponent) {
            return ((TextComponent)comp).getText();
        }
        if (comp instanceof Button) {
            return ((Button)comp).getLabel();
        }
        if (comp instanceof Label) {
            return ((Label)comp).getText();
        }
        if (comp instanceof JScrollPane && (sub = (scr = (JScrollPane)comp).getViewport().getView()) != null) {
            return GuiUtil.getText(sub);
        }
        return comp.toString();
    }

    public static void applyDefaultOrientation(Component comp) {
        GuiUtil.applyOrientation(comp, new Language(Locale.getDefault().getLanguage()).isLeftToRight());
    }

    public static void applyOrientation(Component comp, boolean ltr) {
        GuiUtil.applyOrientation(comp, ltr ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT);
    }

    public static void applyOrientation(Component comp, ComponentOrientation orientation) {
        block3: {
            block2: {
                comp.setComponentOrientation(orientation);
                if (!(comp instanceof JMenu)) break block2;
                JMenu menu = (JMenu)comp;
                int ncomponents = menu.getMenuComponentCount();
                for (int i = 0; i < ncomponents; ++i) {
                    GuiUtil.applyOrientation(menu.getMenuComponent(i), orientation);
                }
                break block3;
            }
            if (!(comp instanceof Container)) break block3;
            Container container = (Container)comp;
            int ncomponents = container.getComponentCount();
            for (int i = 0; i < ncomponents; ++i) {
                GuiUtil.applyOrientation(container.getComponent(i), orientation);
            }
        }
    }

    public static JButton flatten(JButton button) {
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setText(null);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }
}

