/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.util.StringUtil;

public class PathField
extends JPanel
implements Field {
    private transient ActionFactory actions;
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private JList list = new JList(this.model);
    private static final long serialVersionUID = 3256443607736072242L;

    public PathField() {
        this.actions = new ActionFactory(this);
        JPanel buttons = new JPanel(new FlowLayout());
        this.list.setFont(new Font("Monospaced", 0, 12));
        this.list.setSelectionMode(0);
        CWScrollPane scroll = new CWScrollPane(this.list);
        buttons.add(new JButton(this.actions.addAction("Add", BDMsg.gettext("Add", new Object[0]))));
        buttons.add(new JButton(this.actions.addAction("Remove", BDMsg.gettext("Remove", new Object[0]))));
        buttons.add(new JButton(this.actions.addAction("Update", BDMsg.gettext("Update (path)", new Object[0]))));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        this.add((Component)buttons, "Last");
    }

    public void setChoice(Choice param) {
    }

    public String getValue() {
        return StringUtil.join((Object[])this.getArray(), (String)File.pathSeparator);
    }

    public String[] getArray() {
        String[] retcode = new String[this.model.getSize()];
        for (int i = 0; i < retcode.length; ++i) {
            retcode[i] = (String)this.model.getElementAt(i);
        }
        return retcode;
    }

    public void setValue(String value) {
        this.setArray(StringUtil.split((String)value, (String)File.pathSeparator));
    }

    public void setArray(String[] value) {
        this.model = new DefaultComboBoxModel<Object>((Object[])value.clone());
        this.list.setModel(this.model);
    }

    public JComponent getComponent() {
        return this;
    }

    public void doAddPathEntry() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            String path = chooser.getSelectedFile().getPath();
            this.model.addElement(path);
        }
    }

    public void doUpdatePathEntry() {
        JFileChooser chooser = new JFileChooser(this.currentValue());
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            String path = chooser.getSelectedFile().getPath();
            this.model.removeElement(this.currentValue());
            this.model.addElement(path);
        }
    }

    public void doRemovePathEntry() {
        this.model.removeElement(this.currentValue());
    }

    private String currentValue() {
        return (String)this.model.getElementAt(this.list.getSelectedIndex());
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.actions = new ActionFactory(this);
        is.defaultReadObject();
    }
}

