/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.install.InstallManagerComboBoxModel;
import org.crosswire.common.swing.CWOptionPane;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.InstallManager;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.util.IndexDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexResolver {
    private static final Logger log = LoggerFactory.getLogger(IndexResolver.class);

    private IndexResolver() {
    }

    public static void scheduleIndex(final Book book, Component parent) {
        int choice = 1;
        switch (choice) {
            case 0: {
                Installer installer = IndexResolver.selectInstaller(parent);
                if (installer == null) break;
                Throwable ex = null;
                try {
                    IndexDownloader.downloadIndex((Book)book, (Installer)installer);
                }
                catch (InstallException e) {
                    ex = e;
                }
                catch (BookException e) {
                    ex = e;
                }
                catch (IOException e) {
                    ex = e;
                }
                if (ex == null) break;
                log.error("index download failed: ", ex);
                String gtitle = BDMsg.gettext("Download or generate?", new Object[0]);
                StringBuffer gmsg = new StringBuffer(200);
                gmsg.append(BDMsg.gettext("Downloading failed.", new Object[0]));
                gmsg.append("\n");
                gmsg.append(BDMsg.gettext("Do you wish to generate an index anyway?", new Object[0]));
                int yn = CWOptionPane.showConfirmDialog(parent, gmsg.toString(), gtitle, 0, 3);
                if (yn != 0) break;
                Thread work = new Thread(new Runnable(){

                    public void run() {
                        IndexManagerFactory.getIndexManager().scheduleIndexCreation(book);
                    }
                });
                work.start();
                break;
            }
            case 1: {
                Thread work = new Thread(new Runnable(){

                    public void run() {
                        IndexManagerFactory.getIndexManager().scheduleIndexCreation(book);
                    }
                });
                work.start();
                break;
            }
        }
    }

    private static Installer selectInstaller(Component parent) {
        InstallManager insman = new InstallManager();
        Map installers = insman.getInstallers();
        Installer installer = null;
        if (installers.size() == 1) {
            Iterator i$ = installers.values().iterator();
            if (i$.hasNext()) {
                Installer anInstaller;
                installer = anInstaller = (Installer)i$.next();
            }
            assert (installer != null);
        } else {
            JComboBox choice = new JComboBox(new InstallManagerComboBoxModel(insman));
            JLabel label = new JLabel(BDMsg.gettext("Which download site do you wish to use?", new Object[0]));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)label, "North");
            panel.add(choice, "Center");
            String title = BDMsg.gettext("Download an index?", new Object[0]);
            int yn = CWOptionPane.showConfirmDialog(parent, panel, title, 0);
            if (yn == 0) {
                installer = (Installer)choice.getSelectedItem();
            }
        }
        return installer;
    }
}

