/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.versification.BookName;

public class BibleNameCellRenderer
extends DefaultListCellRenderer {
    private boolean abbreviated;
    public static final String PROTOTYPE_BOOK_NAME = "0123456789";
    private static final long serialVersionUID = 3978138859576308017L;

    public BibleNameCellRenderer() {
        this(false);
    }

    public BibleNameCellRenderer(boolean abbreviated) {
        this.abbreviated = abbreviated;
        GuiUtil.applyDefaultOrientation(this);
    }

    public boolean isAbbreviated() {
        return this.abbreviated;
    }

    public void setAbbreviated(boolean newAbbreviated) {
        this.abbreviated = newAbbreviated;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, selected, focus);
        this.setToolTipText(null);
        if (value == null) {
            this.setText(BDMsg.gettext("None", new Object[0]));
            this.setEnabled(false);
        }
        if (value instanceof BookName) {
            BookName bookName = (BookName)value;
            String name = bookName.getLongName();
            this.setText(this.abbreviated ? bookName.getShortName() : name);
            this.setToolTipText(name);
        }
        return comp;
    }
}

