/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JComboBox;
import javax.swing.event.EventListenerList;
import org.crosswire.bibledesktop.book.BibleComboBoxModel;
import org.crosswire.bibledesktop.book.BibleNameCellRenderer;
import org.crosswire.common.swing.NumberCellRenderer;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.versification.BibleBook;
import org.crosswire.jsword.versification.BookName;

public class BibleComboBoxModelSet
implements Serializable {
    private Verse verse = Verse.DEFAULT;
    protected JComboBox cboBook;
    protected JComboBox cboChapter;
    private JComboBox cboVerse;
    protected BibleComboBoxModel mdlBook;
    protected BibleComboBoxModel mdlChapter;
    protected BibleComboBoxModel mdlVerse;
    protected EventListenerList listeners = new EventListenerList();
    private transient ItemListener cil = new CustomItemListener();
    private static final long serialVersionUID = 5365220628525297473L;

    public BibleComboBoxModelSet(JComboBox books, JComboBox chapters, JComboBox verses) {
        this.mdlBook = new BibleComboBoxModel(this, BibleComboBoxModel.Level.BOOK);
        this.setBookComboBox(books);
        this.mdlChapter = new BibleComboBoxModel(this, BibleComboBoxModel.Level.CHAPTER);
        this.setChapterComboBox(chapters);
        if (verses != null) {
            this.mdlVerse = new BibleComboBoxModel(this, BibleComboBoxModel.Level.VERSE);
            this.setVerseComboBox(verses);
        }
    }

    public final void setBookComboBox(JComboBox cboBook) {
        this.cboBook = cboBook;
        cboBook.setModel(this.mdlBook);
        cboBook.addItemListener(this.cil);
        cboBook.setRenderer(new BibleNameCellRenderer(true));
        cboBook.setToolTipText(this.verse.getVersification().getLongName(this.verse.getBook()));
    }

    public final void setChapterComboBox(JComboBox cboChapter) {
        this.cboChapter = cboChapter;
        cboChapter.setModel(this.mdlChapter);
        cboChapter.setPrototypeDisplayValue(999);
        cboChapter.addItemListener(this.cil);
        cboChapter.setRenderer(new NumberCellRenderer());
    }

    public final void setVerseComboBox(JComboBox cboVerse) {
        this.cboVerse = cboVerse;
        cboVerse.setModel(this.mdlVerse);
        cboVerse.setPrototypeDisplayValue(999);
        cboVerse.addItemListener(this.cil);
        cboVerse.setRenderer(new NumberCellRenderer());
    }

    public Verse getVerse() {
        return this.verse;
    }

    public void setVerse(Verse newverse) {
        if (this.verse.equals((Object)newverse)) {
            return;
        }
        Verse oldverse = this.verse;
        this.verse = newverse;
        BibleBook bookval = newverse.getBook();
        BookName bookName = newverse.getVersification().getBookName(bookval);
        if (oldverse.getBook() != bookval || !this.cboBook.getSelectedItem().equals(bookName)) {
            this.cboBook.setSelectedItem(bookName);
            this.cboBook.setToolTipText(bookName.getLongName());
        }
        int chapterval = newverse.getChapter();
        Integer chapternum = chapterval;
        if (oldverse.getChapter() != chapterval || !this.cboChapter.getSelectedItem().equals(chapternum)) {
            this.cboChapter.setSelectedItem(chapternum);
        }
        if (this.cboVerse != null) {
            int verseval = newverse.getVerse();
            Integer versenum = verseval;
            if (oldverse.getVerse() != verseval || !this.cboVerse.getSelectedItem().equals(versenum)) {
                this.cboVerse.setSelectedItem(versenum);
            }
        }
        this.fireContentsChanged();
    }

    public void addActionListener(ActionListener li) {
        this.listeners.add(ActionListener.class, li);
    }

    public void removeActionListener(ActionListener li) {
        this.listeners.remove(ActionListener.class, li);
    }

    protected void fireContentsChanged() {
        Object[] liarray = this.listeners.getListenerList();
        ActionEvent ev = null;
        for (int i = liarray.length - 2; i >= 0; i -= 2) {
            if (liarray[i] != ActionListener.class) continue;
            if (ev == null) {
                ev = new ActionEvent(this, 1001, this.verse.getName());
            }
            ((ActionListener)liarray[i + 1]).actionPerformed(ev);
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.cil = new CustomItemListener();
        is.defaultReadObject();
    }

    final class CustomItemListener
    implements ItemListener {
        CustomItemListener() {
        }

        public void itemStateChanged(ItemEvent ev) {
            if (ev.getStateChange() == 1) {
                Object source = ev.getSource();
                if (source.equals(BibleComboBoxModelSet.this.cboBook)) {
                    BibleComboBoxModelSet.this.mdlChapter.fireContentsChanged(this, 0, BibleComboBoxModelSet.this.mdlChapter.getSize());
                }
                if (BibleComboBoxModelSet.this.mdlVerse != null && (source.equals(BibleComboBoxModelSet.this.cboBook) || source.equals(BibleComboBoxModelSet.this.cboChapter))) {
                    BibleComboBoxModelSet.this.mdlVerse.fireContentsChanged(this, 0, BibleComboBoxModelSet.this.mdlVerse.getSize());
                }
            }
        }
    }
}

