/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.DisplaySelectPane;
import org.crosswire.bibledesktop.book.PassageSelectionPane;
import org.crosswire.common.icu.NumberShaper;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWLabel;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.index.search.SearchType;
import org.crosswire.jsword.versification.DivisionName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedSearchPane
extends JPanel
implements DocumentListener {
    private static final String SPACE = " ";
    private static final String CUSTOM = "";
    protected boolean bailout;
    private transient ActionFactory actions;
    private NumberShaper shaper;
    private Object[] presets = new Object[]{"", DivisionName.BIBLE, DivisionName.PROPHECY, DivisionName.OLD_TESTAMENT, DivisionName.NEW_TESTAMENT, DivisionName.PENTATEUCH, DivisionName.HISTORY, DivisionName.POETRY, DivisionName.MAJOR_PROPHETS, DivisionName.MINOR_PROPHETS, DivisionName.GOSPELS_AND_ACTS, DivisionName.PAULINE_LETTERS, DivisionName.GENERAL_LETTERS};
    private boolean editingRestrict;
    private PassageSelectionPane dlgSelect;
    private JLabel lblPhrase;
    private JLabel lblIncludes;
    private JTextField txtIncludes;
    private JTextField txtPhrase;
    private JLabel lblExcludes;
    private JTextField txtExcludes;
    private JLabel lblSpell;
    private JTextField txtSpell;
    private JLabel lblStartsWith;
    private JTextField txtStartsWith;
    private JLabel lblHeading;
    private JCheckBox chkRank;
    private JLabel lblRank;
    private JSlider sliderRank;
    private JCheckBox chkRestrict;
    private JLabel lblRestrict;
    private JTextField txtRestrict;
    private JButton btnRestrict;
    private JButton btnGo;
    private JLabel lblPresets;
    private JComboBox cboPresets;
    protected JDialog dlgMain;
    private JCheckBox chkHebGrk;
    private JLabel lblHebInc;
    private JTextField txtHebInc;
    private JLabel lblHebExc;
    private JTextField txtHebExc;
    private JLabel lblGrkInc;
    private JTextField txtGrkInc;
    private JLabel lblGrkExc;
    private JTextField txtGrkExc;
    private JCheckBox chkTime;
    private JLabel lblBefore;
    private JTextField txtBefore;
    private JLabel lblAfter;
    private JTextField txtAfter;
    private JLabel lblSummary;
    private JCheckBox chkSummary;
    private JTextArea txtSummary;
    private JScrollPane scrSummary;
    private static final long serialVersionUID = 3977303234983245108L;

    public AdvancedSearchPane() {
        this.initialize();
    }

    private void initialize() {
        this.shaper = new NumberShaper();
        this.actions = new ActionFactory(this);
        JLabel temp = new JLabel();
        Color headBG = SystemColor.control.darker();
        Color headFG = Color.BLACK;
        Font headFont = temp.getFont().deriveFont(1);
        this.lblHeading = CWLabel.createJLabel(BDMsg.gettext("Search for verses with the following details", new Object[0]));
        this.lblHeading.setBorder(BorderFactory.createLineBorder(headBG, 3));
        this.lblHeading.setBackground(headBG);
        this.lblHeading.setForeground(headFG);
        this.lblHeading.setFont(headFont);
        this.lblHeading.setOpaque(true);
        this.lblPhrase = CWLabel.createJLabel(BDMsg.gettext("Includes this phrase:", new Object[0]));
        this.txtPhrase = new JTextField();
        this.txtPhrase.getDocument().addDocumentListener(this);
        this.txtIncludes = new JTextField();
        this.txtIncludes.getDocument().addDocumentListener(this);
        this.lblIncludes = CWLabel.createJLabel(BDMsg.gettext("Includes these words:", new Object[0]));
        this.lblIncludes.setLabelFor(this.txtIncludes);
        this.txtExcludes = new JTextField();
        this.txtExcludes.getDocument().addDocumentListener(this);
        this.lblExcludes = CWLabel.createJLabel(BDMsg.gettext("Excludes all these words:", new Object[0]));
        this.lblExcludes.setLabelFor(this.txtExcludes);
        this.txtSpell = new JTextField();
        this.txtSpell.getDocument().addDocumentListener(this);
        this.lblSpell = CWLabel.createJLabel(BDMsg.gettext("Something like this spelling:", new Object[0]));
        this.lblSpell.setLabelFor(this.txtSpell);
        this.txtStartsWith = new JTextField();
        this.txtStartsWith.getDocument().addDocumentListener(this);
        this.lblStartsWith = CWLabel.createJLabel(BDMsg.gettext("Includes words starting with:", new Object[0]));
        this.lblStartsWith.setLabelFor(this.txtStartsWith);
        this.chkRank = new JCheckBox(this.actions.addAction("HeadRank", BDMsg.gettext("Prioritize the found verses", new Object[0])));
        this.chkRank.setBackground(headBG);
        this.chkRank.setForeground(headFG);
        this.chkRank.setFont(headFont);
        this.lblRank = CWLabel.createJLabel(BDMsg.gettext("Show", new Object[0]));
        this.setLabelRank(DisplaySelectPane.getNumRankedVerses());
        this.lblRank.setVisible(false);
        this.sliderRank = new JSlider(0, 0, DisplaySelectPane.getMaxNumRankedVerses(), DisplaySelectPane.getNumRankedVerses());
        this.sliderRank.setMajorTickSpacing(DisplaySelectPane.getMaxNumRankedVerses() / 5);
        this.sliderRank.setMinorTickSpacing(DisplaySelectPane.getMaxNumRankedVerses() / 20);
        this.sliderRank.setLabelTable(this.createSliderLabels());
        this.sliderRank.setPaintTicks(true);
        this.sliderRank.setPaintLabels(true);
        this.sliderRank.setVisible(false);
        this.sliderRank.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int val = source.getValue();
                if (source.getValueIsAdjusting()) {
                    AdvancedSearchPane.this.setLabelRank(val);
                } else {
                    DisplaySelectPane.setNumRankedVerses(val);
                }
            }
        });
        this.chkRestrict = new JCheckBox(this.actions.addAction("HeadRestrict", BDMsg.gettext("Restrict search to parts of the Bible", new Object[0])));
        this.chkRestrict.setBackground(headBG);
        this.chkRestrict.setForeground(headFG);
        this.chkRestrict.setFont(headFont);
        this.lblPresets = CWLabel.createJLabel(BDMsg.gettext("Preset Ranges:", new Object[0]));
        this.lblPresets.setVisible(false);
        this.cboPresets = new JComboBox<Object>(this.presets);
        this.cboPresets.setVisible(false);
        this.cboPresets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AdvancedSearchPane.this.updatePreset();
            }
        });
        this.lblRestrict = CWLabel.createJLabel(BDMsg.gettext("Include these verses:", new Object[0]));
        this.lblRestrict.setVisible(false);
        this.txtRestrict = new JTextField();
        this.txtRestrict.setVisible(false);
        this.txtRestrict.getDocument().addDocumentListener(this);
        this.btnRestrict = new JButton(this.actions.addAction("RestrictSelect", BDMsg.gettext("Select", new Object[0])));
        this.btnRestrict.setVisible(false);
        this.chkHebGrk = new JCheckBox(this.actions.addAction("HeadOriginal", BDMsg.gettext("Contains Strong's Hebrew and Greek", new Object[0])));
        this.chkHebGrk.setBackground(headBG);
        this.chkHebGrk.setForeground(headFG);
        this.chkHebGrk.setFont(headFont);
        this.lblHebInc = CWLabel.createJLabel(BDMsg.gettext("Includes Hebrew Numbers:", new Object[0]));
        this.lblHebInc.setVisible(false);
        this.txtHebInc = new JTextField();
        this.txtHebInc.setVisible(false);
        this.txtHebInc.getDocument().addDocumentListener(this);
        this.lblHebExc = CWLabel.createJLabel(BDMsg.gettext("Excludes Hebrew Numbers:", new Object[0]));
        this.lblHebExc.setVisible(false);
        this.txtHebExc = new JTextField();
        this.txtHebExc.setVisible(false);
        this.txtHebExc.getDocument().addDocumentListener(this);
        this.lblGrkInc = CWLabel.createJLabel(BDMsg.gettext("Includes Greek Numbers:", new Object[0]));
        this.lblGrkInc.setVisible(false);
        this.txtGrkInc = new JTextField();
        this.txtGrkInc.setVisible(false);
        this.txtGrkInc.getDocument().addDocumentListener(this);
        this.lblGrkExc = CWLabel.createJLabel(BDMsg.gettext("Excludes Greek Numbers:", new Object[0]));
        this.lblGrkExc.setVisible(false);
        this.txtGrkExc = new JTextField();
        this.txtGrkExc.setVisible(false);
        this.txtGrkExc.getDocument().addDocumentListener(this);
        this.chkTime = new JCheckBox(this.actions.addAction("HeadTime", BDMsg.gettext("Narrow search by time period", new Object[0])));
        this.chkTime.setBackground(headBG);
        this.chkTime.setForeground(headFG);
        this.chkTime.setFont(headFont);
        this.lblAfter = CWLabel.createJLabel(BDMsg.gettext("Restrict to verses written after:", new Object[0]));
        this.lblAfter.setVisible(false);
        this.txtAfter = new JTextField();
        this.txtAfter.setVisible(false);
        this.txtAfter.getDocument().addDocumentListener(this);
        this.lblBefore = CWLabel.createJLabel(BDMsg.gettext("Restrict to verses written before:", new Object[0]));
        this.lblBefore.setVisible(false);
        this.txtBefore = new JTextField();
        this.txtBefore.setVisible(false);
        this.txtBefore.getDocument().addDocumentListener(this);
        this.chkSummary = new JCheckBox(this.actions.addAction("HeadSummary", BDMsg.gettext("Show quick search syntax", new Object[0])));
        this.chkSummary.setBackground(headBG);
        this.chkSummary.setForeground(headFG);
        this.chkSummary.setFont(headFont);
        this.lblSummary = CWLabel.createJLabel(BDMsg.gettext("Quick search syntax:", new Object[0]));
        this.lblSummary.setVisible(false);
        this.txtSummary = new JTextArea();
        this.txtSummary.setBackground(SystemColor.control);
        this.txtSummary.setLineWrap(true);
        this.txtSummary.setEditable(false);
        this.txtSummary.setRows(2);
        this.scrSummary = new CWScrollPane(this.txtSummary);
        this.scrSummary.setVisible(false);
        this.btnGo = new JButton(this.actions.addAction("Done", BDMsg.gettext("Search", new Object[0])));
        this.setBorder(BorderFactory.createLineBorder(SystemColor.control, 5));
        this.setLayout(new GridBagLayout());
        int gridy = 0;
        this.add((Component)this.lblHeading, new GridBagConstraints(0, ++gridy, 3, 1, 0.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.lblPhrase, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtPhrase, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblIncludes, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtIncludes, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblExcludes, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtExcludes, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblSpell, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtSpell, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblStartsWith, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtStartsWith, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.chkRank, new GridBagConstraints(0, ++gridy, 3, 1, 0.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.lblRank, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.sliderRank, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.chkRestrict, new GridBagConstraints(0, ++gridy, 3, 1, 0.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.lblPresets, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.cboPresets, new GridBagConstraints(1, gridy, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblRestrict, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtRestrict, new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.btnRestrict, new GridBagConstraints(2, gridy, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.chkSummary, new GridBagConstraints(0, ++gridy, 3, 1, 0.0, 0.0, 21, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.lblSummary, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scrSummary, new GridBagConstraints(1, gridy, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.btnGo, new GridBagConstraints(2, ++gridy, 1, 1, 0.0, 0.0, 15, 0, new Insets(10, 0, 5, 5), 0, 0));
        GuiUtil.applyDefaultOrientation(this);
    }

    public String showInDialog(Component parent, String title, boolean modal, String search) {
        this.txtSummary.setText(search);
        Frame root = JOptionPane.getFrameForComponent(parent);
        this.dlgMain = new JDialog(root);
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        this.bailout = true;
        ActionListener closer = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AdvancedSearchPane.this.dlgMain.dispose();
            }
        };
        this.dlgMain.getContentPane().setLayout(new BorderLayout());
        this.dlgMain.getContentPane().add((Component)this, "Center");
        this.dlgMain.getRootPane().setDefaultButton(this.btnGo);
        this.dlgMain.getRootPane().registerKeyboardAction(closer, esc, 2);
        this.dlgMain.setDefaultCloseOperation(2);
        this.dlgMain.setTitle(title);
        this.dlgMain.setModal(modal);
        GuiUtil.restrainedPack(this.dlgMain, 0.5f, 0.75f);
        GuiUtil.centerOnScreen(this.dlgMain);
        GuiUtil.applyDefaultOrientation(this.dlgMain);
        this.dlgMain.setVisible(true);
        if (this.bailout) {
            return null;
        }
        return this.txtSummary.getText();
    }

    public boolean isRanked() {
        return this.chkRank.isSelected();
    }

    public final void setLabelRank(int val) {
        if (val == 0) {
            this.lblRank.setText(BDMsg.gettext("Show all verses:", new Object[0]));
        } else if (val == 1) {
            this.lblRank.setText(BDMsg.gettext("Show best verse:", new Object[0]));
        } else {
            this.lblRank.setText(BDMsg.gettext("Show {0} verses:", val));
        }
    }

    public void doHeadRank() {
        boolean visible = this.chkRank.isSelected();
        this.lblRank.setVisible(visible);
        this.sliderRank.setVisible(visible);
        if (this.dlgMain != null) {
            this.dlgMain.pack();
        }
    }

    public void doHeadRestrict() {
        boolean visible = this.chkRestrict.isSelected();
        this.lblPresets.setVisible(visible);
        this.cboPresets.setVisible(visible);
        this.lblRestrict.setVisible(visible);
        this.txtRestrict.setVisible(visible);
        this.btnRestrict.setVisible(visible);
        if (this.dlgMain != null) {
            this.dlgMain.pack();
        }
    }

    public void doHeadSummary() {
        boolean visible = this.chkSummary.isSelected();
        this.lblSummary.setVisible(visible);
        this.scrSummary.setVisible(visible);
        if (this.dlgMain != null) {
            this.dlgMain.pack();
        }
    }

    public void doHeadOriginal() {
        boolean visible = this.chkHebGrk.isSelected();
        this.lblHebInc.setVisible(visible);
        this.txtHebInc.setVisible(visible);
        this.lblHebExc.setVisible(visible);
        this.txtHebExc.setVisible(visible);
        this.lblGrkInc.setVisible(visible);
        this.txtGrkInc.setVisible(visible);
        this.lblGrkExc.setVisible(visible);
        this.txtGrkExc.setVisible(visible);
        if (this.dlgMain != null) {
            this.dlgMain.pack();
        }
    }

    public void doHeadTime() {
        boolean visible = this.chkTime.isSelected();
        this.lblBefore.setVisible(visible);
        this.txtBefore.setVisible(visible);
        this.lblAfter.setVisible(visible);
        this.txtAfter.setVisible(visible);
        if (this.dlgMain != null) {
            this.dlgMain.pack();
        }
    }

    public void doRestrictSelect() {
        String passg;
        if (this.dlgSelect == null) {
            this.dlgSelect = new PassageSelectionPane();
        }
        if ((passg = this.dlgSelect.showInDialog(this, BDMsg.gettext("Select Passages to Restrict Search to", new Object[0]), true, this.txtRestrict.getText())) != null) {
            this.cboPresets.setSelectedItem(CUSTOM);
            this.txtRestrict.setText(passg);
        }
    }

    public void doDone() {
        this.bailout = false;
        this.dlgMain.dispose();
    }

    public final void updatePreset() {
        if (this.editingRestrict) {
            return;
        }
        String include = CUSTOM;
        Object obj = this.cboPresets.getSelectedItem();
        if (obj instanceof DivisionName) {
            DivisionName preset = (DivisionName)obj;
            include = preset.getRange();
        }
        this.txtRestrict.setText(include);
    }

    private void updateSearchString() {
        String startsWith;
        String spell;
        String excludes;
        String includes;
        String phrase;
        StringBuilder search = new StringBuilder();
        String restrict = this.txtRestrict.getText();
        if (restrict != null && restrict.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.RANGE.decorate(restrict));
        }
        if ((phrase = this.txtPhrase.getText()) != null && phrase.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.PHRASE.decorate(phrase));
        }
        if ((includes = this.txtIncludes.getText()) != null && includes.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.ALL_WORDS.decorate(includes));
        }
        if ((excludes = this.txtExcludes.getText()) != null && excludes.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.NOT_WORDS.decorate(excludes));
        }
        if ((spell = this.txtSpell.getText()) != null && spell.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.SPELL_WORDS.decorate(spell));
        }
        if ((startsWith = this.txtStartsWith.getText()) != null && startsWith.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(SearchType.START_WORDS.decorate(startsWith));
        }
        this.txtSummary.setText(search.toString());
        this.editingRestrict = true;
        boolean match = false;
        ComboBoxModel model = this.cboPresets.getModel();
        for (int i = 0; !match && i < model.getSize(); ++i) {
            DivisionName element;
            Object obj = model.getElementAt(i);
            if (!(obj instanceof DivisionName) || !(element = (DivisionName)obj).getRange().equalsIgnoreCase(restrict)) continue;
            this.cboPresets.setSelectedIndex(i);
            match = true;
        }
        if (!match) {
            this.cboPresets.setSelectedItem(CUSTOM);
        }
        this.editingRestrict = false;
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
        this.updateSearchString();
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        this.updateSearchString();
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
        this.updateSearchString();
    }

    private Dictionary<Integer, JLabel> createSliderLabels() {
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        int max = DisplaySelectPane.getMaxNumRankedVerses();
        for (int i = 0; i <= max; i += 20) {
            Integer label = i;
            ((Dictionary)labels).put(label, new JLabel(this.shaper.shape(label.toString()), 0));
        }
        return labels;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.actions = new ActionFactory(this);
        is.defaultReadObject();
    }
}

