/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RestrictionType;

public class RangeListModel
extends AbstractListModel {
    private Passage ref;
    private List<Key> ranges;
    private RestrictionType restrict;
    private static final long serialVersionUID = 3761692273179964725L;

    public RangeListModel(RestrictionType theRestriction) {
        this.restrict = theRestriction;
        this.ranges = new ArrayList<Key>();
    }

    public void setRestriction(RestrictionType restrict) {
        this.restrict = restrict;
        this.refresh();
    }

    public RestrictionType getRestriction() {
        return this.restrict;
    }

    public int getSize() {
        return this.ranges.size();
    }

    public Object getElementAt(int index) {
        return this.ranges.get(index);
    }

    public final void setPassage(Passage newRef) {
        this.fireIntervalRemoved(this, 0, this.getSize());
        this.ref = newRef;
        if (this.ref != null) {
            this.ref.optimizeReads();
        }
        this.refresh();
        this.fireIntervalAdded(this, 0, this.getSize());
    }

    public Passage getPassage() {
        return this.ref;
    }

    private void refresh() {
        this.ranges.clear();
        if (this.ref != null) {
            Iterator iter = this.ref.rangeIterator(this.restrict);
            while (iter.hasNext()) {
                this.ranges.add((Key)iter.next());
            }
        }
    }
}

