/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreePath;
import org.crosswire.bibledesktop.book.BibleComboBoxModelSet;
import org.crosswire.bibledesktop.book.BookListCellRenderer;
import org.crosswire.bibledesktop.book.BooksComboBoxModel;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.BookDataDisplayFactory;
import org.crosswire.bibledesktop.display.URIEventListener;
import org.crosswire.bibledesktop.passage.KeyChangeListener;
import org.crosswire.bibledesktop.passage.KeyListListModel;
import org.crosswire.bibledesktop.passage.KeyTreeCellRenderer;
import org.crosswire.bibledesktop.passage.KeyTreeModel;
import org.crosswire.bibledesktop.passage.KeyTreeNode;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.Defaults;
import org.crosswire.jsword.book.KeyType;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PreferredKey;
import org.crosswire.jsword.passage.Verse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBookPane
extends JSplitPane
implements BookDataDisplay {
    private transient BookDataDisplay display;
    private transient Book book;
    protected transient BibleComboBoxModelSet set;
    private Component commentaryPicker;
    private Component genBookKeyScroller;
    private JTree genBookKeyTree;
    private JList bookList;
    private JSplitPane sptMain;
    private Component dictionaryKeyScroller;
    private JList dictionaryKeyList;
    private static final Logger log = LoggerFactory.getLogger(MultiBookPane.class);
    private static final long serialVersionUID = 3616449020667442997L;

    public MultiBookPane() {
        this.init();
        this.bookList.setSelectedValue(Defaults.getDailyDevotional(), true);
    }

    private void init() {
        this.display = BookDataDisplayFactory.createBookDataDisplay();
        Component bookPicker = this.createBookPicker();
        this.commentaryPicker = this.createCommentaryPicker();
        this.dictionaryKeyScroller = this.createDictionaryPicker();
        this.genBookKeyScroller = this.createGenBookPicker();
        CWScrollPane scrDisplay = new CWScrollPane(this.display.getComponent());
        this.sptMain = new FixedSplitPane(false);
        this.sptMain.setOrientation(0);
        this.sptMain.setResizeWeight(0.2);
        this.sptMain.setTopComponent(new JPanel());
        this.sptMain.setBottomComponent(scrDisplay);
        this.setOrientation(0);
        this.setTopComponent(bookPicker);
        this.setBottomComponent(this.sptMain);
        this.setBorder(null);
        SplitPaneUI thisUI = this.getUI();
        if (thisUI instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)thisUI).getDivider().setBorder(null);
        }
    }

    public void clearBookData() {
        this.setBookData(null, null);
    }

    public void setBookData(Book[] books, Key key) {
        this.display.setBookData(books, key);
    }

    public void setCompareBooks(boolean compare) {
        this.display.setCompareBooks(compare);
    }

    public void refresh() {
        this.display.refresh();
    }

    public Component getComponent() {
        return this;
    }

    public void copy() {
        this.display.copy();
    }

    public Key getKey() {
        return (Key)this.dictionaryKeyList.getSelectedValue();
    }

    public void addKeyChangeListener(KeyChangeListener listener) {
        this.display.addKeyChangeListener(listener);
    }

    public void removeKeyChangeListener(KeyChangeListener listener) {
        this.display.removeKeyChangeListener(listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.display.propertyChange(evt);
    }

    public void addURIEventListener(URIEventListener listener) {
        this.display.addURIEventListener(listener);
    }

    public void removeURIEventListener(URIEventListener listener) {
        this.display.removeURIEventListener(listener);
    }

    public Book[] getBooks() {
        return new Book[]{this.book};
    }

    public Book getFirstBook() {
        return this.book;
    }

    public void setWord(String data) {
        if (this.book == null) {
            return;
        }
        try {
            Key key = this.book.getKey(data);
            this.dictionaryKeyList.setSelectedValue(key, true);
        }
        catch (NoSuchKeyException ex) {
            return;
        }
    }

    public void setKey(Key key) {
        Passage ref;
        if (key instanceof Passage && (ref = (Passage)key).countVerses() > 0) {
            this.set.setVerse(ref.getVerseAt(0));
        }
        this.updateDisplay();
    }

    public void selectBook(Book selectedBook) {
        this.bookList.setSelectedValue(selectedBook, true);
    }

    private Component createBookPicker() {
        BookFilter filter = BookFilters.getNonBibles();
        BooksComboBoxModel mdlBooks = new BooksComboBoxModel(filter);
        this.bookList = new JList();
        this.bookList.setVisibleRowCount(6);
        this.bookList.setSelectionMode(0);
        this.bookList.setModel(mdlBooks);
        this.bookList.setCellRenderer(new BookListCellRenderer());
        this.bookList.setPrototypeCellValue("0123456789");
        this.bookList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                if (ev.getValueIsAdjusting()) {
                    return;
                }
                MultiBookPane.this.newBook();
            }
        });
        CWScrollPane scroller = new CWScrollPane(this.bookList);
        GuiUtil.applyDefaultOrientation(scroller);
        return scroller;
    }

    private Component createCommentaryPicker() {
        JComboBox cboBooks = new JComboBox();
        JComboBox cboChaps = new JComboBox();
        JComboBox cboVerse = new JComboBox();
        this.set = new BibleComboBoxModelSet(cboBooks, cboChaps, cboVerse);
        this.set.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                MultiBookPane.this.updateDisplay();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(cboBooks, null);
        panel.add(cboChaps, null);
        panel.add(cboVerse, null);
        GuiUtil.applyDefaultOrientation(panel);
        return panel;
    }

    private Component createDictionaryPicker() {
        this.dictionaryKeyList = new JList();
        this.dictionaryKeyList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                MultiBookPane.this.newEntry();
            }
        });
        CWScrollPane scroller = new CWScrollPane(this.dictionaryKeyList);
        GuiUtil.applyDefaultOrientation(scroller);
        return scroller;
    }

    private Component createGenBookPicker() {
        this.genBookKeyTree = new JTree();
        this.genBookKeyTree.setModel(new KeyTreeModel(null));
        this.genBookKeyTree.setShowsRootHandles(true);
        this.genBookKeyTree.setRootVisible(false);
        this.genBookKeyTree.putClientProperty("JTree.lineStyle", "Angled");
        this.genBookKeyTree.setCellRenderer(new KeyTreeCellRenderer());
        this.genBookKeyTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent ev) {
                MultiBookPane.this.selected();
            }
        });
        CWScrollPane scroller = new CWScrollPane(this.genBookKeyTree);
        GuiUtil.applyDefaultOrientation(scroller);
        return scroller;
    }

    final void newBook() {
        if (this.book != null) {
            KeyType currentCategory = this.book.getBookMetaData().getKeyType();
            if (KeyType.LIST.equals((Object)currentCategory)) {
                this.dictionaryKeyList.ensureIndexIsVisible(0);
                this.dictionaryKeyList.setModel(new KeyListListModel(null));
            } else if (KeyType.TREE.equals((Object)currentCategory)) {
                this.genBookKeyTree.scrollRowToVisible(0);
                KeyTreeModel model = new KeyTreeModel(null);
                this.genBookKeyTree.setModel(model);
            }
        }
        this.display.clearBookData();
        Object selected = this.bookList.getSelectedValue();
        if (selected != null) {
            Book selectedBook = (Book)selected;
            KeyType category = selectedBook.getBookMetaData().getKeyType();
            int dividerLocation = this.sptMain.getDividerLocation();
            if (KeyType.VERSE.equals((Object)category)) {
                this.updateDisplay();
                this.sptMain.setTopComponent(this.commentaryPicker);
            } else if (KeyType.LIST.equals((Object)category)) {
                this.book = selectedBook;
                Key key = this.book.getGlobalKeyList();
                KeyListListModel model = new KeyListListModel(key);
                this.dictionaryKeyList.setModel(model);
                if (this.book instanceof PreferredKey) {
                    PreferredKey pref = (PreferredKey)this.book;
                    Key prefkey = pref.getPreferred();
                    this.dictionaryKeyList.setSelectedValue(prefkey, true);
                }
                this.sptMain.setTopComponent(this.dictionaryKeyScroller);
            } else {
                this.book = selectedBook;
                Key key = this.book.getGlobalKeyList();
                KeyTreeModel model = new KeyTreeModel(key);
                this.genBookKeyTree.setModel(model);
                this.sptMain.setTopComponent(this.genBookKeyScroller);
            }
            this.sptMain.setDividerLocation(dividerLocation);
        }
    }

    final void updateDisplay() {
        Book selectedBook = (Book)this.bookList.getSelectedValue();
        if (selectedBook == null) {
            log.warn("no selected book");
            return;
        }
        Verse verse = this.set.getVerse();
        this.display.setBookData(new Book[]{selectedBook}, (Key)verse);
    }

    final void newEntry() {
        Key key = (Key)this.dictionaryKeyList.getSelectedValue();
        if (key != null) {
            this.display.setBookData(new Book[]{this.book}, key);
        }
    }

    void selected() {
        KeyTreeNode node;
        TreePath path = this.genBookKeyTree.getSelectionPath();
        if (path != null && (node = (KeyTreeNode)path.getLastPathComponent()) != null) {
            this.display.setBookData(new Book[]{this.book}, node.getKey());
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.display = BookDataDisplayFactory.createBookDataDisplay();
        this.book = null;
        this.set = null;
        is.defaultReadObject();
    }
}

