/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.BibleBook;
import org.crosswire.jsword.versification.Versification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RestrictionType
extends Enum<RestrictionType> {
    public static final /* enum */ RestrictionType NONE = new RestrictionType(){

        public boolean isSameScope(Versification v11n, Verse start, Verse end) {
            return true;
        }

        public VerseRange blur(Versification v11n, VerseRange range, int blurDown, int blurUp) {
            Verse start = v11n.subtract(range.getStart(), blurDown);
            Verse end = v11n.add(range.getEnd(), blurUp);
            return new VerseRange(v11n, start, end);
        }

        public VerseRange blur(Versification v11n, Verse verse, int blurDown, int blurUp) {
            Verse start = v11n.subtract(verse, blurDown);
            Verse end = v11n.add(verse, blurUp);
            return new VerseRange(v11n, start, end);
        }

        public VerseRange toRange(Versification v11n, Verse verse, int count) {
            Verse end = verse;
            if (count > 1) {
                end = v11n.add(verse, count - 1);
            }
            return new VerseRange(v11n, verse, end);
        }
    };
    public static final /* enum */ RestrictionType CHAPTER = new RestrictionType(){

        public boolean isSameScope(Versification v11n, Verse start, Verse end) {
            return v11n.isSameChapter(start, end);
        }

        public VerseRange blur(Versification v11n, VerseRange range, int blurDown, int blurUp) {
            Verse start = range.getStart();
            BibleBook startBook = start.getBook();
            int startChapter = start.getChapter();
            int startVerse = start.getVerse() - blurDown;
            Verse end = range.getEnd();
            BibleBook endBook = end.getBook();
            int endChapter = end.getChapter();
            int endVerse = end.getVerse() + blurUp;
            startVerse = Math.max(startVerse, 0);
            endVerse = Math.min(endVerse, v11n.getLastVerse(endBook, endChapter));
            Verse newStart = new Verse(v11n, startBook, startChapter, startVerse);
            Verse newEnd = new Verse(v11n, endBook, endChapter, endVerse);
            return new VerseRange(v11n, newStart, newEnd);
        }

        public VerseRange blur(Versification v11n, Verse verse, int blurDown, int blurUp) {
            BibleBook book = verse.getBook();
            int chapter = verse.getChapter();
            int startVerse = verse.getVerse() - blurDown;
            int endVerse = verse.getVerse() + blurUp;
            startVerse = Math.max(startVerse, 0);
            endVerse = Math.min(endVerse, v11n.getLastVerse(book, chapter));
            Verse start = new Verse(v11n, book, chapter, startVerse);
            Verse end = new Verse(v11n, book, chapter, endVerse);
            return new VerseRange(v11n, start, end);
        }

        public VerseRange toRange(Versification v11n, Verse verse, int count) {
            Verse end = v11n.add(verse, count - 1);
            return new VerseRange(v11n, verse, end);
        }
    };
    private static RestrictionType defaultBlurRestriction;
    private static final /* synthetic */ RestrictionType[] $VALUES;

    public static RestrictionType[] values() {
        return (RestrictionType[])$VALUES.clone();
    }

    public static RestrictionType valueOf(String name) {
        return Enum.valueOf(RestrictionType.class, name);
    }

    public abstract boolean isSameScope(Versification var1, Verse var2, Verse var3);

    public abstract VerseRange blur(Versification var1, VerseRange var2, int var3, int var4);

    public abstract VerseRange blur(Versification var1, Verse var2, int var3, int var4);

    public abstract VerseRange toRange(Versification var1, Verse var2, int var3);

    public int toInteger() {
        return this.ordinal();
    }

    public static RestrictionType fromString(String name) {
        for (RestrictionType v : RestrictionType.values()) {
            if (!v.name().equalsIgnoreCase(name)) continue;
            return v;
        }
        assert (false);
        return null;
    }

    public static RestrictionType fromInteger(int i) {
        for (RestrictionType v : RestrictionType.values()) {
            if (v.ordinal() != i) continue;
            return v;
        }
        assert (false);
        return null;
    }

    public static void setBlurRestriction(int value) {
        defaultBlurRestriction = RestrictionType.fromInteger(value);
    }

    public static int getBlurRestriction() {
        return RestrictionType.getDefaultBlurRestriction().toInteger();
    }

    public static RestrictionType getDefaultBlurRestriction() {
        return defaultBlurRestriction;
    }

    static {
        $VALUES = new RestrictionType[]{NONE, CHAPTER};
        defaultBlurRestriction = NONE;
    }
}

