/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageType;
import org.crosswire.jsword.passage.ReadOnlyPassage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.SynchronizedPassage;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;

public final class PassageKeyFactory {
    private static PassageType defaultType = PassageType.SPEED;
    private static PassageKeyFactory keyf = new PassageKeyFactory();

    private PassageKeyFactory() {
    }

    public static PassageKeyFactory instance() {
        return keyf;
    }

    public Key createEmptyKeyList(Versification v11n) {
        return defaultType.createEmptyPassage(v11n);
    }

    public Key getGlobalKeyList(Versification v11n) {
        return new ReadOnlyPassage(KeyUtil.getPassage(v11n.getAllVerses()), true);
    }

    public Key getValidKey(Versification v11n, String passageReference, Key basis) {
        try {
            return this.getKey(v11n, passageReference, basis);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList(v11n);
        }
    }

    public Key getValidKey(Versification v11n, String passageReference) {
        return this.getValidKey(v11n, passageReference, null);
    }

    public Passage getKey(Versification v11n, String passageReference, Key basis) throws NoSuchKeyException {
        try {
            return defaultType.createPassage(v11n, passageReference, basis);
        }
        catch (NoSuchKeyException e) {
            try {
                return defaultType.createPassage(v11n, this.normalize(passageReference), basis);
            }
            catch (NoSuchKeyException ex) {
                return defaultType.createPassage(v11n, this.mungOsisRef(passageReference), basis);
            }
        }
    }

    public Passage getKey(Versification v11n, String passageReference) throws NoSuchKeyException {
        return this.getKey(v11n, passageReference, null);
    }

    public static void setDefaultType(PassageType newDefaultType) {
        defaultType = newDefaultType;
    }

    public static PassageType getDefaultType() {
        return defaultType;
    }

    public static void setDefaultPassage(int newDefaultType) {
        PassageKeyFactory.setDefaultType(PassageType.fromInteger(newDefaultType));
    }

    public static int getDefaultPassage() {
        return PassageType.toInteger(defaultType);
    }

    public static Passage getSynchronizedPassage(Passage ref) {
        return new SynchronizedPassage(ref);
    }

    public static Passage getReadOnlyPassage(Passage ref, boolean ignore) {
        return new ReadOnlyPassage(ref, ignore);
    }

    static byte[] toBinaryRepresentation(Passage ref) {
        Versification v11n = ref.getVersification();
        int maxOrdinal = v11n.maximumOrdinal();
        int verses = ref.countVerses();
        int ranges = ref.countRanges(RestrictionType.NONE);
        int bitwiseSize = maxOrdinal / 8;
        int rangedSize = ranges * 4 + 1;
        int distinctSize = verses * 2 + 1;
        if (bitwiseSize <= rangedSize && bitwiseSize <= distinctSize) {
            int arraySize = PassageKeyFactory.binarySize(3) + maxOrdinal / 8 + 1;
            byte[] buffer = new byte[arraySize];
            int index = 0;
            index += PassageKeyFactory.toBinary(buffer, index, 0, 3);
            for (Key aKey : ref) {
                Verse verse = (Verse)aKey;
                int ord = verse.getOrdinal();
                int idx0 = ord / 8 + index;
                int bit = ord % 8 - 1;
                int n = idx0;
                buffer[n] = (byte)(buffer[n] | 1 << bit);
            }
            return buffer;
        }
        if (distinctSize <= rangedSize) {
            int arraySize = PassageKeyFactory.binarySize(3) + PassageKeyFactory.binarySize(maxOrdinal) + verses * PassageKeyFactory.binarySize(maxOrdinal);
            byte[] buffer = new byte[arraySize];
            int index = 0;
            index += PassageKeyFactory.toBinary(buffer, index, 1, 3);
            index += PassageKeyFactory.toBinary(buffer, index, verses, maxOrdinal);
            for (Key aKey : ref) {
                Verse verse = (Verse)aKey;
                int ord = verse.getOrdinal();
                index += PassageKeyFactory.toBinary(buffer, index, ord, maxOrdinal);
            }
            return buffer;
        }
        int arraySize = PassageKeyFactory.binarySize(3) + PassageKeyFactory.binarySize(maxOrdinal / 2) + 2 * ranges * PassageKeyFactory.binarySize(maxOrdinal);
        byte[] buffer = new byte[arraySize];
        int index = 0;
        index += PassageKeyFactory.toBinary(buffer, index, 2, 3);
        index += PassageKeyFactory.toBinary(buffer, index, ranges, maxOrdinal / 2);
        Iterator<VerseRange> it = ref.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            VerseRange range = it.next();
            index += PassageKeyFactory.toBinary(buffer, index, range.getStart().getOrdinal(), maxOrdinal);
            index += PassageKeyFactory.toBinary(buffer, index, range.getCardinality(), maxOrdinal);
        }
        return buffer;
    }

    static Passage fromBinaryRepresentation(byte[] buffer) throws NoSuchKeyException {
        Versification rs = Versifications.instance().getVersification("KJV");
        int maxOrdinal = rs.maximumOrdinal();
        Passage ref = (Passage)keyf.createEmptyKeyList(rs);
        AbstractPassage aref = null;
        if (ref instanceof AbstractPassage) {
            aref = (AbstractPassage)ref;
            aref.raiseEventSuppresion();
            aref.raiseNormalizeProtection();
        }
        int[] index = new int[]{0};
        int type = PassageKeyFactory.fromBinary(buffer, index, 3);
        switch (type) {
            case 0: {
                for (int ord = 1; ord <= maxOrdinal; ++ord) {
                    int idx0 = ord / 8 + index[0];
                    int bit = ord % 8 - 1;
                    if ((buffer[idx0] & 1 << bit) == 0) continue;
                    ref.add(rs.decodeOrdinal(ord));
                }
                break;
            }
            case 1: {
                int verses = PassageKeyFactory.fromBinary(buffer, index, maxOrdinal);
                for (int i = 0; i < verses; ++i) {
                    int ord = PassageKeyFactory.fromBinary(buffer, index, maxOrdinal);
                    ref.add(rs.decodeOrdinal(ord));
                }
                break;
            }
            case 2: {
                int ranges = PassageKeyFactory.fromBinary(buffer, index, maxOrdinal / 2);
                for (int i = 0; i < ranges; ++i) {
                    int ord = PassageKeyFactory.fromBinary(buffer, index, maxOrdinal);
                    int len = PassageKeyFactory.fromBinary(buffer, index, maxOrdinal);
                    ref.add(RestrictionType.NONE.toRange(rs, rs.decodeOrdinal(ord), len));
                }
                break;
            }
            default: {
                throw new NoSuchKeyException(JSOtherMsg.lookupText("Unknown passage type.", new Object[0]));
            }
        }
        if (aref != null) {
            aref.lowerEventSuppressionAndTest();
            aref.lowerNormalizeProtection();
        }
        return ref;
    }

    public static Passage readPassage(Reader in) throws IOException, NoSuchKeyException {
        Versification rs = Versifications.instance().getVersification("KJV");
        Passage ref = (Passage)keyf.createEmptyKeyList(rs);
        ref.readDescription(in);
        return ref;
    }

    protected static int binarySize(int max) {
        if (max < 256) {
            return 1;
        }
        if (max < 65536) {
            return 2;
        }
        if (max < 0x1000000) {
            return 3;
        }
        return 4;
    }

    protected static int toBinary(byte[] buffer, int index, int number, int max) {
        assert (number >= 0) : "No -ve output " + number;
        assert (number <= max) : "number " + number + " > max " + max;
        if (max < 256) {
            buffer[index] = (byte)number;
            return 1;
        }
        if (max < 65536) {
            buffer[index + 0] = (byte)(number >>> 8);
            buffer[index + 1] = (byte)(number >>> 0);
            return 2;
        }
        if (max < 0x1000000) {
            buffer[index + 0] = (byte)(number >>> 16);
            buffer[index + 1] = (byte)(number >>> 8);
            buffer[index + 2] = (byte)(number >>> 0);
            return 3;
        }
        buffer[index + 0] = (byte)(number >>> 24);
        buffer[index + 1] = (byte)(number >>> 16);
        buffer[index + 2] = (byte)(number >>> 8);
        buffer[index + 3] = (byte)(number >>> 0);
        return 4;
    }

    protected static int fromBinary(byte[] buffer, int[] index, int max) {
        int n = index[0];
        index[0] = n + 1;
        int b0 = buffer[n] & 0xFF;
        if (max < 256) {
            return b0;
        }
        int n2 = index[0];
        index[0] = n2 + 1;
        int b1 = buffer[n2] & 0xFF;
        if (max < 65536) {
            return (b0 << 8) + (b1 << 0);
        }
        int n3 = index[0];
        index[0] = n3 + 1;
        int b2 = buffer[n3] & 0xFF;
        if (max < 0x1000000) {
            return (b0 << 16) + (b1 << 8) + (b2 << 0);
        }
        int n4 = index[0];
        index[0] = n4 + 1;
        int b3 = buffer[n4] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + (b3 << 0);
    }

    private String mungOsisRef(String passageReference) {
        return passageReference.replace(' ', ';');
    }

    private String normalize(String passageReference) {
        if (passageReference == null) {
            return null;
        }
        int size = passageReference.length();
        StringBuilder buf = new StringBuilder(size * 2);
        char curChar = ' ';
        boolean isNumber = false;
        boolean wasNumberOrMarker = false;
        boolean isEndMarker = false;
        boolean isNumberOrMarker = false;
        int i = 0;
        while (i < size) {
            curChar = passageReference.charAt(i);
            isNumber = Character.isDigit(curChar);
            isEndMarker = curChar == '$' || curChar == 'f' && (i + 1 < size ? (int)passageReference.charAt(i + 1) : 32) == 102;
            boolean bl = isNumberOrMarker = isNumber || isEndMarker;
            if (wasNumberOrMarker) {
                if (isNumber) {
                    buf.append(", ");
                } else if (isEndMarker) {
                    buf.append('-');
                } else if (Character.isLetter(curChar)) {
                    buf.append(' ');
                }
                wasNumberOrMarker = false;
            }
            if (isNumberOrMarker) {
                wasNumberOrMarker = true;
                buf.append(curChar);
                ++i;
                if (curChar == 'f') {
                    buf.append('f');
                    ++i;
                } else if (curChar != '$') {
                    while (i < size && Character.isDigit(curChar = passageReference.charAt(i))) {
                        buf.append(curChar);
                        ++i;
                    }
                }
                while (i < size && Character.isWhitespace(passageReference.charAt(i))) {
                    ++i;
                }
                continue;
            }
            buf.append(curChar);
            ++i;
        }
        return buf.toString();
    }
}

