/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.FileUtil;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.index.Index;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexPolicy;
import org.crosswire.jsword.index.IndexPolicyAdapter;
import org.crosswire.jsword.index.IndexStatus;
import org.crosswire.jsword.index.lucene.IndexMetadata;
import org.crosswire.jsword.index.lucene.InstalledIndex;
import org.crosswire.jsword.index.lucene.LuceneIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexManager
implements IndexManager {
    private IndexPolicy policy = new IndexPolicyAdapter();
    private URI baseFolderURI;
    protected static final Map<Book, Index> INDEXES = new HashMap<Book, Index>();
    public static final String DIR_LUCENE = "lucene";
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexManager.class);

    public LuceneIndexManager() {
        try {
            this.baseFolderURI = CWProject.instance().getWritableProjectSubdir(DIR_LUCENE, false);
        }
        catch (IOException ex) {
            log.error("Failed to find lucene index storage area.", (Throwable)ex);
        }
    }

    public boolean isIndexed(Book book) {
        try {
            if (book == null) {
                return false;
            }
            URI storage = this.getStorageArea(book);
            return NetUtil.isDirectory(storage);
        }
        catch (IOException ex) {
            log.error("Failed to find lucene index storage area.", (Throwable)ex);
            return false;
        }
    }

    public Index getIndex(Book book) throws BookException {
        try {
            Index reply = INDEXES.get(book);
            if (reply == null) {
                URI storage = this.getStorageArea(book);
                reply = new LuceneIndex(book, storage);
                INDEXES.put(book, reply);
            }
            return reply;
        }
        catch (IOException ex) {
            throw new BookException(JSMsg.gettext("Failed to initialize Lucene search engine.", new Object[0]), ex);
        }
    }

    public boolean needsReindexing(Book book) {
        float installedV = InstalledIndex.instance().getInstalledIndexVersion(book);
        if (installedV < IndexMetadata.instance().getLatestIndexVersion(book)) {
            log.info("{}: needs reindexing, Installed index version @{}", (Object)book.getBookMetaData().getInitials(), (Object)Float.toString(installedV));
            return true;
        }
        return false;
    }

    public void closeAllIndexes() {
        for (Index index : INDEXES.values()) {
            index.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleIndexCreation(Book book) {
        book.setIndexStatus(IndexStatus.SCHEDULED);
        IndexStatus finalStatus = IndexStatus.UNDONE;
        try {
            URI storage = this.getStorageArea(book);
            LuceneIndex index = new LuceneIndex(book, storage, this.policy);
            if (NetUtil.getAsFile(storage).exists()) {
                finalStatus = IndexStatus.DONE;
                INDEXES.put(book, index);
                InstalledIndex.instance().storeLatestVersionAsInstalledIndexMetadata(book);
            }
        }
        catch (IOException e) {
            Reporter.informUser((Object)this, e);
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, e);
        }
        finally {
            book.setIndexStatus(finalStatus);
        }
    }

    public void installDownloadedIndex(Book book, URI tempDest) throws BookException {
        try {
            URI storage = this.getStorageArea(book);
            File zip = NetUtil.getAsFile(tempDest);
            IOUtil.unpackZip(zip, NetUtil.getAsFile(storage));
        }
        catch (IOException ex) {
            throw new BookException(JSMsg.gettext("Installation failed.", new Object[0]), ex);
        }
    }

    public void deleteIndex(Book book) throws BookException {
        File tempPath = null;
        try {
            File storage;
            String finalCanonicalPath;
            Index index = INDEXES.get(book);
            if (index != null) {
                index.close();
            }
            if ((tempPath = new File((finalCanonicalPath = (storage = NetUtil.getAsFile(this.getStorageArea(book))).getCanonicalPath()) + '.' + IndexStatus.CREATING.toString())).exists()) {
                FileUtil.delete(tempPath);
            }
            if (!storage.renameTo(tempPath = new File(finalCanonicalPath + '.' + IndexStatus.CREATING.toString()))) {
                throw new BookException(JSMsg.gettext("Failed to delete search index.", new Object[0]));
            }
            book.setIndexStatus(IndexStatus.UNDONE);
            InstalledIndex.instance().removeFromInstalledIndexMetadata(book);
        }
        catch (IOException ex) {
            throw new BookException(JSMsg.gettext("Failed to delete search index.", new Object[0]), ex);
        }
        FileUtil.delete(tempPath);
    }

    public IndexPolicy getIndexPolicy() {
        return this.policy;
    }

    public void setIndexPolicy(IndexPolicy policy) {
        this.policy = policy != null ? policy : new IndexPolicyAdapter();
    }

    protected URI getStorageArea(Book book) throws IOException {
        BookMetaData bmd = book.getBookMetaData();
        String driverName = bmd.getDriverName();
        String bookName = bmd.getInitials();
        assert (driverName != null);
        assert (bookName != null);
        return NetUtil.lengthenURI(this.baseFolderURI, driverName + "/" + bookName);
    }
}

