/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import java.io.IOException;
import java.net.URI;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.index.lucene.IndexMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstalledIndex {
    public static final String INSTALLED_INDEX_DEFAULT_VERSION = "Installed.Index.DefaultVersion";
    public static final String PREFIX_INSTALLED_INDEX_VERSION_BOOK_OVERRIDE = "Installed.Index.Version.Book.";
    public static final float DEFAULT_INSTALLED_INDEX_VERSION = 1.2f;
    private PropertyMap props;
    private Object writeLock = new Object();
    private static String metadataFileComment = "Search index properties that stay persistent on clients computer. Used during index upgrades.\nContains Default index version, used for all searchable books, if book specific over-ride is not found.\nJSword adds a Book specific installed index version over-ride property, after an index creation. ";
    private static InstalledIndex myInstance = new InstalledIndex();
    private static final Logger log = LoggerFactory.getLogger(InstalledIndex.class);

    public static InstalledIndex instance() {
        return myInstance;
    }

    public float getInstalledIndexDefaultVersion() {
        float toReturn = 1.2f;
        String value = this.props.get(INSTALLED_INDEX_DEFAULT_VERSION);
        if (value != null) {
            toReturn = Float.parseFloat(value);
        }
        return toReturn;
    }

    public float getInstalledIndexVersion(Book b) {
        if (b == null) {
            return this.getInstalledIndexDefaultVersion();
        }
        String value = this.props.get(PREFIX_INSTALLED_INDEX_VERSION_BOOK_OVERRIDE + IndexMetadata.getBookIdentifierPropSuffix(b.getBookMetaData()), this.props.get(INSTALLED_INDEX_DEFAULT_VERSION));
        if (value == null) {
            return 1.2f;
        }
        return Float.parseFloat(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLatestVersionAsInstalledIndexMetadata(Book b) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.props.put(PREFIX_INSTALLED_INDEX_VERSION_BOOK_OVERRIDE + IndexMetadata.getBookIdentifierPropSuffix(b.getBookMetaData()), String.valueOf(IndexMetadata.instance().getLatestIndexVersion(b)));
            NetUtil.storeProperties(this.props, this.getPropertyFileURI(), metadataFileComment);
        }
    }

    public URI getPropertyFileURI() {
        return CWProject.instance().getWritableURI("lucene/" + this.getClass().getName(), ".properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeInstalledIndexMetadata() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            NetUtil.storeProperties(this.props, this.getPropertyFileURI(), metadataFileComment);
        }
    }

    private InstalledIndex() {
        this.props = new PropertyMap();
        URI propURI = this.getPropertyFileURI();
        try {
            if (NetUtil.canRead(propURI)) {
                this.props = NetUtil.loadProperties(propURI);
            }
            if (this.props.size() == 0) {
                this.props.put(INSTALLED_INDEX_DEFAULT_VERSION, String.valueOf(1.2f));
                this.storeInstalledIndexMetadata();
            }
        }
        catch (IOException e) {
            log.error("Property file read error: " + propURI.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInstalledIndexMetadata(PropertyMap updateProps) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.props.putAll(updateProps);
            NetUtil.storeProperties(this.props, this.getPropertyFileURI(), metadataFileComment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInstalledIndexMetadata(Book b, String installedIndexVersionToStore) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.props.put(PREFIX_INSTALLED_INDEX_VERSION_BOOK_OVERRIDE + IndexMetadata.getBookIdentifierPropSuffix(b.getBookMetaData()), installedIndexVersionToStore);
            NetUtil.storeProperties(this.props, this.getPropertyFileURI(), metadataFileComment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromInstalledIndexMetadata(Book b) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.props.remove(PREFIX_INSTALLED_INDEX_VERSION_BOOK_OVERRIDE + IndexMetadata.getBookIdentifierPropSuffix(b.getBookMetaData()));
            NetUtil.storeProperties(this.props, this.getPropertyFileURI(), metadataFileComment);
        }
    }
}

