/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.examples;

import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.index.search.DefaultSearchModifier;
import org.crosswire.jsword.index.search.DefaultSearchRequest;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageTally;

public class Speed
implements Runnable {
    private long startTime;
    private long endTime;
    private Book book;

    public Speed(Book book) {
        this.book = book;
    }

    public void run() {
        try {
            PassageTally tally;
            this.startTime = System.currentTimeMillis();
            DefaultSearchModifier modifier = new DefaultSearchModifier();
            modifier.setRanked(true);
            int rankCount = 35;
            modifier.setMaxResults(rankCount);
            String param = "\"In the beginning god created the heavens and the earth\"";
            Key results = this.book.find(new DefaultSearchRequest(param, modifier));
            if (results instanceof PassageTally) {
                tally = (PassageTally)results;
                tally.setOrdering(PassageTally.Order.TALLY);
                tally.trimVerses(rankCount);
                this.dummyDisplay(tally);
                results = null;
            }
            param = "\"for god so loves the world that he gave his only begotten son\"";
            if (results instanceof PassageTally) {
                tally = (PassageTally)results;
                tally.setOrdering(PassageTally.Order.TALLY);
                tally.trimVerses(rankCount);
                this.dummyDisplay(tally);
                results = null;
            }
            String nextInput = this.book.find("aaron & manna").getName();
            Key key = this.book.getKey(nextInput);
            Passage ref = KeyUtil.getPassage(key);
            ref.trimVerses(35);
            this.dummyDisplay(ref);
            ref = null;
            this.endTime = System.currentTimeMillis();
        }
        catch (BookException ex) {
            Reporter.informUser((Object)this, ex);
        }
        catch (NoSuchKeyException ex) {
            Reporter.informUser((Object)this, ex);
        }
    }

    private void dummyDisplay(Passage ref) throws BookException {
        new BookData(this.book, ref).getOsisFragment();
    }

    public long getBenchmark() {
        if (this.startTime == 0L || this.endTime == 0L) {
            throw new IllegalStateException("The benchmark has not finished yet.");
        }
        return this.endTime - this.startTime;
    }

    public Book getBook() {
        return this.book;
    }

    public void setBook(Book book) {
        this.book = book;
    }
}

