/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.examples;

import java.util.List;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.passage.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReadEverything {
    private static int count;
    private static final Logger log;

    private ReadEverything() {
    }

    public static void main(String[] args) {
        log.warn("*** Reading all installed Bibles");
        BookFilter filter = null;
        List<Book> books = ReadEverything.getBooks(filter);
        for (Book book : books) {
            if (book.isLocked()) {
                log.warn("****** Skipping: [{}] {} ({})", new Object[]{book.getInitials(), book.getName(), book.getBookCategory()});
                continue;
            }
            log.warn("****** Reading: [{}] {} ({})", new Object[]{book.getInitials(), book.getName(), book.getBookCategory()});
            Key set = book.getGlobalKeyList();
            ReadEverything.testReadMultiple(book, set);
        }
    }

    private static List<Book> getBooks(BookFilter filter) {
        if (filter == null) {
            return Books.installed().getBooks();
        }
        return Books.installed().getBooks(filter);
    }

    private static void testReadMultiple(Book book, Key set) {
        long start = System.currentTimeMillis();
        int entries = 0;
        count = 0;
        boolean first = true;
        for (Key key : set) {
            if (first) {
                first = false;
                if (key.getName().length() == 0) continue;
            }
            ReadEverything.testReadSingle(book, key, entries);
            ++entries;
        }
        long end = System.currentTimeMillis();
        float time = (float)(end - start) / 1000.0f;
        if (count > 0) {
            log.info("Tested: book={} entries={} time={}s errors={} ({}ms per entry)", new Object[]{book.getInitials(), Integer.toString(entries), Float.toString(time), Integer.toString(count), Float.toString(1000.0f * time / (float)entries)});
        } else {
            log.info("Tested: book={} entries={} time={}s ({}ms per entry)", new Object[]{book.getInitials(), Integer.toString(entries), Float.toString(time), Float.toString(1000.0f * time / (float)entries)});
        }
    }

    private static void testReadSingle(Book book, Key key, int entry) {
        BookException oops = null;
        try {
            log.debug("reading: {}/{}:{}", new Object[]{book.getInitials(), Integer.toString(entry), key.getName()});
            BookData data = new BookData(book, key);
            if (data.getOsisFragment() == null) {
                log.warn("No output from: {},{}", (Object)book.getInitials(), (Object)key.getOsisID());
            }
        }
        catch (BookException ex) {
            oops = ex;
        }
        if (oops != null && ++count < 5) {
            log.error("Unexpected error reading: {}, {}, {}, {}", new Object[]{book.getInitials(), Integer.toString(entry), key.getOsisID(), key.getClass().getName(), oops});
        }
    }

    static {
        log = LoggerFactory.getLogger(ReadEverything.class);
    }
}

