/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.crosswire.common.util.FileUtil;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.basic.AbstractBookDriver;
import org.crosswire.jsword.book.sword.BookType;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordBookPath;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.index.IndexStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwordBookDriver
extends AbstractBookDriver {
    private static final BookDriver INSTANCE = new SwordBookDriver();
    private static final Logger LOGGER = LoggerFactory.getLogger(SwordBookDriver.class);

    @Override
    public String getDriverName() {
        return "Sword";
    }

    @Override
    public Book[] getBooks() {
        File[] dirs = SwordBookPath.getSwordPath();
        HashSet<Book> valid = new HashSet<Book>(dirs.length + dirs.length / 3);
        for (int j = 0; j < dirs.length; ++j) {
            this.getBooks(valid, dirs[j]);
        }
        return valid.toArray(new Book[valid.size()]);
    }

    private void getBooks(Set<Book> valid, File bookDir) {
        File mods = new File(bookDir, "mods.d");
        if (!mods.isDirectory()) {
            LOGGER.debug("mods.d directory at {} does not exist", (Object)mods);
            return;
        }
        String[] bookConfs = SwordBookPath.getBookList(mods);
        URI bookDirURI = NetUtil.getURI(bookDir);
        for (int i = 0; i < bookConfs.length; ++i) {
            String bookConf = bookConfs[i];
            try {
                SwordBookMetaData sbmd = null;
                File configfile = new File(mods, bookConf);
                if (configfile.exists()) {
                    sbmd = new SwordBookMetaData(configfile, bookDirURI);
                }
                if (sbmd == null) {
                    LOGGER.error("The book's configuration files is not supported.");
                    continue;
                }
                if (!sbmd.isSupported()) {
                    LOGGER.error("The book's configuration files is not supported. -> Initials [{}], Driver=[{}], Versification=[{}], Book type=[{}], Book category=[{}]", new Object[]{sbmd.getInitials(), sbmd.getDriver(), sbmd.getProperty("Versification"), sbmd.getBookType(), sbmd.getBookCategory()});
                    continue;
                }
                sbmd.setDriver(this);
                Book book = this.createBook(sbmd);
                if (valid.contains(book)) continue;
                valid.add(book);
                IndexManager imanager = IndexManagerFactory.getIndexManager();
                if (imanager.isIndexed(book)) {
                    sbmd.setIndexStatus(IndexStatus.DONE);
                    continue;
                }
                sbmd.setIndexStatus(IndexStatus.UNDONE);
                continue;
            }
            catch (IOException e) {
                LOGGER.warn("Couldn't create SwordBookMetaData", (Throwable)e);
                continue;
            }
            catch (BookException e) {
                LOGGER.warn("Couldn't create SwordBookMetaData", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isDeletable(Book dead) {
        SwordBookMetaData sbmd = (SwordBookMetaData)dead.getBookMetaData();
        File confFile = sbmd.getConfigFile();
        return confFile != null && confFile.exists();
    }

    @Override
    public void delete(Book dead) throws BookException {
        URI loc;
        SwordBookMetaData sbmd = (SwordBookMetaData)dead.getBookMetaData();
        File confFile = sbmd.getConfigFile();
        if (confFile == null || !confFile.exists()) {
            throw new BookException(JSMsg.gettext("Unable to delete: {0}", confFile));
        }
        List<File> failures = FileUtil.delete(confFile);
        if (failures.isEmpty() && (loc = sbmd.getLocation()) != null) {
            File bookDir = new File(loc.getPath());
            failures = FileUtil.delete(bookDir);
            Books.installed().removeBook(dead);
        }
        if (!failures.isEmpty()) {
            throw new BookException(JSMsg.gettext("Unable to delete: {0}", failures.get(0)));
        }
    }

    public static BookDriver instance() {
        return INSTANCE;
    }

    public static void registerNewBook(SwordBookMetaData sbmd) throws BookException {
        BookDriver[] drivers = Books.installed().getDriversByClass(SwordBookDriver.class);
        for (int i = 0; i < drivers.length; ++i) {
            SwordBookDriver sdriver = (SwordBookDriver)drivers[i];
            Book book = sdriver.createBook(sbmd);
            Books.installed().addBook(book);
        }
    }

    private Book createBook(SwordBookMetaData sbmd) throws BookException {
        BookType modtype = sbmd.getBookType();
        if (modtype == null || modtype.getBookCategory() == null) {
            throw new BookException(JSOtherMsg.lookupText("Unsupported type: {0} when reading {1}", new Object[0]));
        }
        return modtype.createBook(sbmd);
    }
}

