/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.crosswire.common.util.PluginUtil;
import org.crosswire.jsword.book.filter.SourceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SourceFilterFactory {
    private static Map<String, SourceFilter> filters = new HashMap<String, SourceFilter>();
    private static final Logger log = LoggerFactory.getLogger(SourceFilterFactory.class);
    private static volatile SourceFilter deft;

    private SourceFilterFactory() {
    }

    public static SourceFilter getFilter(String lookup) {
        SourceFilter reply = filters.get(lookup.toLowerCase(Locale.ENGLISH));
        if (reply == null) {
            reply = deft;
        }
        return reply.clone();
    }

    public static SourceFilter getDefaultFilter() {
        return deft.clone();
    }

    public static void addFilter(String name, SourceFilter instance) {
        filters.put(name.toLowerCase(Locale.ENGLISH), instance);
    }

    static {
        Map<String, Class<SourceFilter>> map = PluginUtil.getImplementorsMap(SourceFilter.class);
        try {
            Class<SourceFilter> cdeft = map.remove("default");
            deft = cdeft.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Failed to get default filter, will attempt to use first", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("Failed to get default filter, will attempt to use first", (Throwable)e);
        }
        SourceFilter instance = null;
        for (Map.Entry<String, Class<SourceFilter>> entry : map.entrySet()) {
            try {
                Class<SourceFilter> clazz = entry.getValue();
                instance = clazz.newInstance();
                SourceFilterFactory.addFilter(entry.getKey(), instance);
            }
            catch (InstantiationException ex) {
                log.error("Failed to add filter", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                log.error("Failed to add filter", (Throwable)ex);
            }
        }
        if (deft == null) {
            deft = instance;
        }
    }
}

