/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.passage.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataPolice {
    private static boolean reporting;
    private static final Logger LOGGER;

    private DataPolice() {
    }

    public static void report(Book book, Key key, String message) {
        if (!reporting) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        BookMetaData bmd = book.getBookMetaData();
        if (bmd != null) {
            buf.append(bmd.getInitials());
        }
        if (bmd != null && key != null) {
            buf.append(':');
        }
        if (key != null) {
            buf.append(key.getOsisID());
        }
        buf.append(": ");
        buf.append(message);
        LOGGER.info(buf.toString());
    }

    public static synchronized boolean isReporting() {
        return reporting;
    }

    public static synchronized void setReporting(boolean reporting) {
        DataPolice.reporting = reporting;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DataPolice.class);
    }
}

