/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import org.crosswire.jsword.JSMsg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BookCategory {
    BIBLE("Biblical Texts", JSMsg.gettext("Biblical Texts", new Object[0])),
    DICTIONARY("Lexicons / Dictionaries", JSMsg.gettext("Dictionaries", new Object[0])),
    COMMENTARY("Commentaries", JSMsg.gettext("Commentaries", new Object[0])),
    DAILY_DEVOTIONS("Daily Devotional", JSMsg.gettext("Daily Devotionals", new Object[0])),
    GLOSSARY("Glossaries", JSMsg.gettext("Glossaries", new Object[0])),
    QUESTIONABLE("Cults / Unorthodox / Questionable Material", JSMsg.gettext("Cults / Unorthodox / Questionable Materials", new Object[0])),
    ESSAYS("Essays", JSMsg.gettext("Essays", new Object[0])),
    IMAGES("Images", JSMsg.gettext("Images", new Object[0])),
    MAPS("Maps", JSMsg.gettext("Maps", new Object[0])),
    GENERAL_BOOK("Generic Books", JSMsg.gettext("General Books", new Object[0])),
    OTHER("Other", JSMsg.gettext("Other", new Object[0]));

    private transient String name;
    private transient String externalName;

    private BookCategory(String name, String externalName) {
        this.name = name;
        this.externalName = externalName;
    }

    public static BookCategory fromString(String name) {
        for (BookCategory o : BookCategory.values()) {
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        return OTHER;
    }

    public static BookCategory fromExternalString(String name) {
        for (BookCategory o : BookCategory.values()) {
            if (!o.externalName.equalsIgnoreCase(name)) continue;
            return o;
        }
        return OTHER;
    }

    public static BookCategory fromInteger(int i) {
        for (BookCategory o : BookCategory.values()) {
            if (i != o.ordinal()) continue;
            return o;
        }
        return OTHER;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.externalName;
    }
}

